"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleInvalidEcs = handleInvalidEcs;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleInvalidEcs({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const ecsInvalidEcsGraph = _prompts.ECS_INVALID_PROMPT.pipe(model).pipe(outputParser);
  const usesFinalMapping = state === null || state === void 0 ? void 0 : state.useFinalMapping;
  const mapping = usesFinalMapping ? state.finalMapping : state.currentMapping;
  const result = await ecsInvalidEcsGraph.invoke({
    ecs: state.ecs,
    current_mapping: JSON.stringify(mapping, null, 2),
    ex_answer: state.exAnswer,
    combined_samples: state.combinedSamples,
    invalid_ecs_fields: state.invalidEcsFields
  });
  return {
    [usesFinalMapping ? 'finalMapping' : 'currentMapping']: result,
    lastExecutedChain: 'invalidEcs'
  };
}