"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDownstreamServiceResource = getDownstreamServiceResource;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _maybe2 = require("../../../../common/utils/maybe");
var _document_type = require("../../../../common/document_type");
var _term_query = require("../../../../common/utils/term_query");
var _apm = require("../../../../common/es_fields/apm");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDownstreamServiceResource({
  traceId,
  start,
  end,
  apmEventClient
}) {
  var _maybe;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.SPAN_DESTINATION_SERVICE_RESOURCE]);
  const response = await apmEventClient.search('get_error_group_main_statistics', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.SpanEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    track_total_hits: false,
    size: 1,
    _source: ['span.destination.service'],
    query: {
      bool: {
        filter: [...(0, _term_query.termQuery)(_apm.TRACE_ID, traceId), ...(0, _term_query.termQuery)(_apm.EVENT_OUTCOME, 'failure'), ...(0, _server.rangeQuery)(start, end), {
          exists: {
            field: _apm.SPAN_DESTINATION_SERVICE_RESOURCE
          }
        }]
      }
    },
    fields: requiredFields
  });
  const fields = (_maybe = (0, _maybe2.maybe)(response.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields;
  const event = fields && (0, _utils.accessKnownApmEventFields)(fields).requireFields(requiredFields);
  return event === null || event === void 0 ? void 0 : event[_apm.SPAN_DESTINATION_SERVICE_RESOURCE];
}