"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRandomSampler = getRandomSampler;
var _seedrandom = _interopRequireDefault(require("seedrandom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRandomSampler({
  coreStart,
  request,
  probability
}) {
  var _coreStart$security$a;
  let seed = 1;
  const username = (_coreStart$security$a = coreStart.security.authc.getCurrentUser(request)) === null || _coreStart$security$a === void 0 ? void 0 : _coreStart$security$a.username;
  if (username) {
    seed = Math.abs((0, _seedrandom.default)(username).int32());
  }
  return {
    probability,
    seed
  };
}