"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlManageJobsHref = useMlManageJobsHref;
var _public = require("@kbn/ml-plugin/public");
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../context/url_params_context/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMlManageJobsHref({
  jobId
} = {}) {
  const {
    plugins: {
      ml
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    // hardcoding a custom default of 1 hour since the default kibana timerange of 15 minutes is shorter than the ML interval
    rangeFrom = 'now-1h',
    rangeTo = 'now'
  } = urlParams;
  const mlADLink = (0, _public.useMlManagementHref)(ml, {
    page: _public.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
    pageState: {
      groupIds: ['apm'],
      jobId,
      globalState: {
        time: {
          from: rangeFrom,
          to: rangeTo
        },
        refreshInterval: {
          pause: true,
          value: 10000
        }
      }
    }
  });
  return mlADLink;
}