"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertingProps = useAlertingProps;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _apm_service_context = require("../../context/apm_service/apm_service_context");
var _use_service_transaction_types_fetcher = require("../../context/apm_service/use_service_transaction_types_fetcher");
var _use_service_agent_fetcher = require("../../context/apm_service/use_service_agent_fetcher");
var _use_preferred_data_source_and_bucket_size = require("../../hooks/use_preferred_data_source_and_bucket_size");
var _use_time_range = require("../../hooks/use_time_range");
var _get_comparison_chart_theme = require("../../components/shared/time_comparison/get_comparison_chart_theme");
var _helpers = require("../../components/alerting/ui_components/alert_details_app_section/helpers");
var _timezone = require("../../components/shared/charts/helper/timezone");
var _document_type = require("../../../common/document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAlertingProps({
  rule,
  serviceName,
  kuery = '',
  rangeFrom,
  rangeTo,
  defaultTransactionType
}) {
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const timeZone = (0, _timezone.getTimeZone)(uiSettings);
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.TransactionMetric,
    numBuckets: 100
  });
  const {
    transactionTypes
  } = (0, _use_service_transaction_types_fetcher.useServiceTransactionTypesFetcher)({
    serviceName,
    start,
    end,
    documentType: preferred === null || preferred === void 0 ? void 0 : preferred.source.documentType,
    rollupInterval: preferred === null || preferred === void 0 ? void 0 : preferred.source.rollupInterval
  });
  const {
    agentName
  } = (0, _use_service_agent_fetcher.useServiceAgentFetcher)({
    serviceName,
    start,
    end
  });
  const currentTransactionType = (0, _apm_service_context.getTransactionType)({
    transactionTypes,
    transactionType: defaultTransactionType,
    agentName
  });
  const params = rule.params;
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const [latencyAggregationType, setLatencyAggregationType] = (0, _react.useState)((0, _helpers.getAggsTypeFromRule)(params.aggregationType));
  const [transactionType, setTransactionType] = (0, _react.useState)(currentTransactionType);
  (0, _react.useEffect)(() => {
    setTransactionType(currentTransactionType);
  }, [currentTransactionType]);
  (0, _react.useEffect)(() => {
    if (defaultTransactionType) {
      setTransactionType(defaultTransactionType);
    }
  }, [defaultTransactionType]);
  return {
    transactionType,
    transactionTypes,
    setTransactionType,
    latencyAggregationType,
    setLatencyAggregationType,
    comparisonChartTheme,
    timeZone
  };
}