"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupTemplate = ServiceGroupTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _apm_main_template = require("./apm_main_template");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/service_group_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceGroupTemplate({
  pageTitle,
  pageHeader,
  pagePath,
  children,
  environmentFilter = true,
  serviceGroupContextTab,
  ...pageTemplateProps
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query,
    query: {
      serviceGroup: serviceGroupId
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/service-map');
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceGroupId) {
      return callApmApi('GET /internal/apm/service-group', {
        params: {
          query: {
            serviceGroup: serviceGroupId
          }
        }
      });
    }
  }, [serviceGroupId]);
  const serviceGroupName = data === null || data === void 0 ? void 0 : data.serviceGroup.groupName;
  const loadingServiceGroupName = !!serviceGroupId && !serviceGroupName;
  const isAllServices = !serviceGroupId;
  const serviceGroupsLink = router.link('/service-groups', {
    query: {
      ...query,
      serviceGroup: ''
    }
  });
  const serviceGroupsPageTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexStart",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "l",
    style: {
      width: 180
    },
    isLoading: loadingServiceGroupName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, serviceGroupName || _i18n.i18n.translate('xpack.apm.serviceGroup.allServices.title', {
    defaultMessage: 'Service inventory'
  }))));
  const tabs = useTabs(serviceGroupContextTab);
  const selectedTab = tabs.find(({
    isSelected
  }) => isSelected);

  // this is only used for building the breadcrumbs for the service group page
  (0, _use_breadcrumb.useBreadcrumb)(() => !serviceGroupName ? [{
    title: pageTitle,
    href: pagePath
  }] : [{
    title: _i18n.i18n.translate('xpack.apm.serviceInventory.breadcrumb.title', {
      defaultMessage: 'Service inventory'
    }),
    href: router.link('/services', {
      query
    })
  }, {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.breadcrumb.title', {
      defaultMessage: 'Service groups'
    }),
    href: serviceGroupsLink
  }, {
    title: serviceGroupName,
    href: router.link('/services', {
      query
    })
  }, ...(selectedTab ? [{
    title: selectedTab.breadcrumbLabel || selectedTab.label,
    href: selectedTab.href
  }] : [])], [pagePath, pageTitle, query, router, selectedTab, serviceGroupName, serviceGroupsLink], {
    omitRootOnServerless: true
  });
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, (0, _extends2.default)({
    pageTitle: serviceGroupsPageTitle,
    pageHeader: {
      tabs,
      breadcrumbs: !isAllServices ? [{
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 21
          }
        }), ' ', _i18n.i18n.translate('xpack.apm.serviceGroups.breadcrumb.return', {
          defaultMessage: 'Return to service groups'
        })),
        color: 'primary',
        'aria-current': false,
        href: serviceGroupsLink
      }] : undefined,
      ...pageHeader
    },
    environmentFilter: environmentFilter,
    showServiceGroupSaveButton: !isAllServices,
    showServiceGroupsNav: isAllServices,
    selectedNavButton: isAllServices ? 'allServices' : 'serviceGroups'
  }, pageTemplateProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }), children);
}
function useTabs(selectedTab) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/service-map');
  const tabs = [{
    key: 'service-inventory',
    breadcrumbLabel: _i18n.i18n.translate('xpack.apm.serviceGroup.serviceInventory', {
      defaultMessage: 'Inventory'
    }),
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "baseline",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroup.serviceInventory', {
      defaultMessage: 'Inventory'
    }))),
    href: router.link('/services', {
      query
    })
  }, {
    key: 'service-map',
    label: _i18n.i18n.translate('xpack.apm.serviceGroup.serviceMap', {
      defaultMessage: 'Service map'
    }),
    href: router.link('/service-map', {
      query
    })
  }];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label,
    breadcrumbLabel
  }) => ({
    href,
    label,
    isSelected: key === selectedTab,
    breadcrumbLabel
  }));
}