"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstanceDetails = InstanceDetails;
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _apm = require("../../../../../common/es_fields/apm");
var _infra_metrics = require("../../../../../common/es_fields/infra_metrics");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _key_value_filter_list = require("../../../shared/key_value_filter_list");
var _utils = require("../../../shared/kuery_bar/utils");
var _service_icons = require("../../../shared/service_icons");
var _use_instance_details_fetcher = require("./use_instance_details_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_instances_table/intance_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function toKeyValuePairs({
  keys,
  data,
  isFilterable = true
}) {
  return keys.map(key => ({
    key,
    value: (0, _lodash.get)(data, key),
    isFilterable
  }));
}
const serviceDetailsKeys = [_apm.SERVICE_NODE_NAME, _apm.SERVICE_VERSION, _apm.SERVICE_RUNTIME_NAME, _apm.SERVICE_RUNTIME_VERSION];
const containerDetailsKeys = [_apm.CONTAINER_ID, _apm.HOST_NAME, _apm.KUBERNETES_POD_UID, _apm.KUBERNETES_POD_NAME];
const metricsKubernetesDetailsKeys = [_infra_metrics.KUBERNETES_CONTAINER_NAME, _infra_metrics.KUBERNETES_NAMESPACE, _infra_metrics.KUBERNETES_REPLICASET_NAME, _infra_metrics.KUBERNETES_DEPLOYMENT_NAME];
const cloudDetailsKeys = [_apm.CLOUD_AVAILABILITY_ZONE, _apm.CLOUD_INSTANCE_ID, _apm.CLOUD_INSTANCE_NAME, _apm.CLOUD_MACHINE_TYPE, _apm.CLOUD_PROVIDER];
function InstanceDetails({
  serviceName,
  serviceNodeName,
  kuery
}) {
  var _data$kubernetes, _data$kubernetes$pod, _data$agent, _data$cloud;
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    data,
    status
  } = (0, _use_instance_details_fetcher.useInstanceDetailsFetcher)({
    serviceName,
    serviceNodeName
  });
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '50%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      "data-test-subj": "loadingSpinner",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }));
  }
  if (!data) {
    return null;
  }
  const addKueryBarFilter = ({
    key,
    value
  }) => {
    (0, _utils.pushNewItemToKueryBar)({
      kuery,
      history,
      key,
      value
    });
  };
  const serviceDetailsKeyValuePairs = toKeyValuePairs({
    keys: serviceDetailsKeys,
    data
  });
  const containerDetailsKeyValuePairs = toKeyValuePairs({
    keys: containerDetailsKeys,
    data
  });
  const metricsKubernetesKeyValuePairs = toKeyValuePairs({
    keys: metricsKubernetesDetailsKeys,
    data,
    isFilterable: false
  });
  const cloudDetailsKeyValuePairs = toKeyValuePairs({
    keys: cloudDetailsKeys,
    data
  });
  const containerType = (_data$kubernetes = data.kubernetes) !== null && _data$kubernetes !== void 0 && (_data$kubernetes$pod = _data$kubernetes.pod) !== null && _data$kubernetes$pod !== void 0 && _data$kubernetes$pod.name ? 'Kubernetes' : 'Docker';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_key_value_filter_list.KeyValueFilterList, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.instanceTable.details.serviceTitle', {
      defaultMessage: 'Service'
    }),
    icon: (0, _customIcons.getAgentIcon)((_data$agent = data.agent) === null || _data$agent === void 0 ? void 0 : _data$agent.name, isDarkMode),
    keyValueList: serviceDetailsKeyValuePairs,
    onClickFilter: addKueryBarFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_key_value_filter_list.KeyValueFilterList, {
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.instanceTable.details.containerTitle', {
      defaultMessage: 'Container'
    }),
    icon: (0, _service_icons.getContainerIcon)(containerType),
    keyValueList: [...containerDetailsKeyValuePairs, ...metricsKubernetesKeyValuePairs],
    onClickFilter: addKueryBarFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_key_value_filter_list.KeyValueFilterList, {
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.instanceTable.details.cloudTitle', {
      defaultMessage: 'Cloud'
    }),
    icon: (0, _customIcons.getCloudProviderIcon)((_data$cloud = data.cloud) === null || _data$cloud === void 0 ? void 0 : _data$cloud.provider),
    keyValueList: cloudDetailsKeyValuePairs,
    onClickFilter: addKueryBarFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })));
}