"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLogs = ServiceLogs;
exports.getContainerShouldClauses = getContainerShouldClauses;
exports.getInfrastructureFilter = getInfrastructureFilter;
exports.getServiceShouldClauses = getServiceShouldClauses;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_kibana = require("../../../context/kibana_context/use_kibana");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_logs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceLogs() {
  const {
    services: {
      logsShared
    }
  } = (0, _use_kibana.useKibana)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/logs', '/mobile-services/{serviceName}/logs');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const timeRange = (0, _react.useMemo)(() => ({
    start,
    end
  }), [start, end]);
  const {
    data: assetFilter,
    status
  } = (0, _use_fetcher.useFetcher)(async callApmApi => {
    if (start == null || end == null) {
      return;
    }
    const {
      containerIds
    } = await callApmApi('GET /internal/apm/services/{serviceName}/infrastructure_attributes', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end
        }
      }
    });
    return getInfrastructureFilter({
      containerIds,
      environment,
      serviceName
    });
  }, [environment, kuery, serviceName, start, end]);
  const internalLogFilters = (0, _react.useMemo)(() => {
    return assetFilter != null ? [assetFilter] : [];
  }, [assetFilter]);
  const documentLogFilters = (0, _react.useMemo)(() => {
    if (!kuery) {
      return [];
    }
    try {
      return [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery))];
    } catch (err) {
      // Invalid/incomplete query, return empty array to avoid breaking the component
      return [];
    }
  }, [kuery]);
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS || status === _use_fetcher.FETCH_STATUS.LOADING && (internalLogFilters.length > 0 || documentLogFilters.length > 0)) {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview, {
      documentFilters: documentLogFilters,
      nonHighlightingFilters: internalLogFilters,
      timeRange: timeRange,
      height: "60vh",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    });
  } else if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview.ErrorContent, {
      error: new Error('Failed to fetch service details'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview.LoadingContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 12
      }
    });
  }
}
function getInfrastructureFilter({
  containerIds,
  environment,
  serviceName
}) {
  return {
    bool: {
      should: [...getServiceShouldClauses({
        environment,
        serviceName
      }), ...getContainerShouldClauses({
        containerIds
      })],
      minimum_should_match: 1
    }
  };
}
function getServiceShouldClauses({
  environment,
  serviceName
}) {
  const serviceNameFilter = {
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  };
  if (environment === _environment_filter_values.ENVIRONMENT_ALL.value) {
    return [serviceNameFilter];
  } else {
    return [{
      bool: {
        filter: [serviceNameFilter, {
          term: {
            [_apm.SERVICE_ENVIRONMENT]: environment
          }
        }]
      }
    }, {
      bool: {
        filter: [serviceNameFilter],
        must_not: [{
          exists: {
            field: _apm.SERVICE_ENVIRONMENT
          }
        }]
      }
    }];
  }
}
function getContainerShouldClauses({
  containerIds = []
}) {
  if (containerIds.length === 0) {
    return [];
  }
  return [{
    bool: {
      filter: [{
        terms: {
          [_apm.CONTAINER_ID]: containerIds
        }
      }],
      must_not: [{
        term: {
          [_apm.SERVICE_NAME]: '*'
        }
      }]
    }
  }];
}