"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addGeneratedActionValues = addGeneratedActionValues;
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _get_es_query_config = require("../../lib/get_es_query_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function addGeneratedActionValues(actions = [], systemActions = [], context) {
  const uiSettingClient = context.uiSettings.asScopedToClient(context.unsecuredSavedObjectsClient);
  const esQueryConfig = await (0, _get_es_query_config.getEsQueryConfig)(uiSettingClient);
  const generateDSL = (kql, filters) => {
    try {
      return JSON.stringify((0, _esQuery.buildEsQuery)(undefined, [{
        query: kql,
        language: 'kuery'
      }], filters, esQueryConfig));
    } catch (e) {
      throw _boom.default.badRequest(`Invalid KQL: ${e.message}`);
    }
  };
  return {
    actions: actions.map(action => {
      var _generateDSL;
      const {
        alertsFilter,
        uuid,
        ...restAction
      } = action;
      return {
        ...restAction,
        uuid: uuid || (0, _uuid.v4)(),
        ...(alertsFilter ? {
          alertsFilter: {
            ...alertsFilter,
            query: alertsFilter.query ? {
              ...alertsFilter.query,
              dsl: (_generateDSL = generateDSL(alertsFilter.query.kql, alertsFilter.query.filters)) !== null && _generateDSL !== void 0 ? _generateDSL : ''
            } : undefined
          }
        } : {})
      };
    }),
    systemActions: systemActions.map(systemAction => ({
      ...systemAction,
      uuid: systemAction.uuid || (0, _uuid.v4)()
    }))
  };
}