"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFindRuleTemplatesQueryV1 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFindRuleTemplatesQueryV1 = query => ({
  perPage: query.per_page,
  page: query.page,
  search: query.search,
  defaultSearchOperator: query.default_search_operator,
  sortField: query.sort_field,
  sortOrder: query.sort_order,
  ruleTypeId: query.rule_type_id,
  tags: query.tags ? Array.isArray(query.tags) ? query.tags : [query.tags] : undefined
});
exports.transformFindRuleTemplatesQueryV1 = transformFindRuleTemplatesQueryV1;