"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapAutoFillScheduler = getGapAutoFillScheduler;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _schemas = require("../schemas");
var _transforms = require("../../transforms");
var _authorization = require("../../../../../authorization");
var _audit_events = require("../../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../../saved_objects");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getGapAutoFillScheduler(context, params) {
  try {
    _schemas.getGapAutoFillSchedulerSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating gap auto fill scheduler get parameters "${JSON.stringify(params)}" - ${error.message}`);
  }
  try {
    var _context$auditLogger;
    const result = await (0, _utils.getGapAutoFillSchedulerSO)({
      context,
      id: params.id,
      operation: _authorization.ReadOperations.GetGapAutoFillScheduler,
      authAuditAction: _audit_events.GapAutoFillSchedulerAuditAction.GET
    });
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.gapAutoFillSchedulerAuditEvent)({
      action: _audit_events.GapAutoFillSchedulerAuditAction.GET,
      savedObject: {
        type: _saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE,
        id: params.id,
        name: result.attributes.name
      }
    }));
    return (0, _transforms.transformSavedObjectToGapAutoFillSchedulerResult)({
      savedObject: result
    });
  } catch (err) {
    var _err$output;
    const errorMessage = `Failed to get gap fill auto scheduler by id: ${params.id}`;
    if ((err === null || err === void 0 ? void 0 : (_err$output = err.output) === null || _err$output === void 0 ? void 0 : _err$output.statusCode) === 404) {
      context.logger.info(`${errorMessage} - ${err}`);
    } else {
      context.logger.error(`${errorMessage} - ${err}`);
    }
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}