"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flappingSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("@kbn/alerting-types/flapping/v1");
var _v2 = require("../../../validation/validate_flapping/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flappingSchema = exports.flappingSchema = _configSchema.schema.object({
  look_back_window: _configSchema.schema.number({
    meta: {
      description: 'The minimum number of runs in which the threshold must be met.'
    },
    min: _v.MIN_LOOK_BACK_WINDOW,
    max: _v.MAX_LOOK_BACK_WINDOW
  }),
  status_change_threshold: _configSchema.schema.number({
    meta: {
      description: 'The minimum number of times an alert must switch states in the look back window.'
    },
    min: _v.MIN_STATUS_CHANGE_THRESHOLD,
    max: _v.MAX_STATUS_CHANGE_THRESHOLD
  })
}, {
  validate: _v2.validateFlapping,
  meta: {
    description: 'When flapping detection is turned on, alerts that switch quickly between active and recovered states are identified as “flapping” and notifications are reduced.'
  }
});