"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findResponseSchema = exports.findQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../response");
var _constants = require("../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findQuerySchema = exports.findQuerySchema = _configSchema.schema.object({
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 0
  }),
  rule_ids: _configSchema.schema.maybe(_configSchema.schema.string()),
  initiator: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.backfillInitiator.USER), _configSchema.schema.literal(_constants.backfillInitiator.SYSTEM)])),
  start: _configSchema.schema.maybe(_configSchema.schema.string()),
  sort_field: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('createdAt'), _configSchema.schema.literal('start')])),
  sort_order: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')]))
}, {
  validate({
    start,
    end
  }) {
    if (start) {
      const parsedStart = Date.parse(start);
      if (isNaN(parsedStart)) {
        return `[start]: query start must be valid date`;
      }
    }
    if (end) {
      const parsedEnd = Date.parse(end);
      if (isNaN(parsedEnd)) {
        return `[end]: query end must be valid date`;
      }
    }
  }
});
const findResponseSchema = exports.findResponseSchema = _configSchema.schema.object({
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number(),
  total: _configSchema.schema.number(),
  data: _configSchema.schema.arrayOf(_response.backfillResponseSchemaV1)
});