"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _render_custom_toolbar = require("@kbn/unified-data-table/src/components/custom_toolbar/render_custom_toolbar");
var _embeddable_menu = require("./embeddable_menu");
var _selected_patterns = require("./selected_patterns");
var _create_categorization_job = require("../create_categorization_job");
var _field_selector = require("./field_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/discover_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DiscoverTabs = ({
  renderViewModeToggle,
  randomSampler,
  openInDiscover,
  selectedCategories,
  loadCategories,
  fields,
  setSelectedField,
  selectedField,
  minimumTimeRangeOption,
  setMinimumTimeRangeOption,
  data,
  dataview,
  earliest,
  latest,
  query
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "unifiedDataTableToolbar",
    css: _render_custom_toolbar.styles.toolbar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, renderViewModeToggle(data === null || data === void 0 ? void 0 : data.categories.length)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, selectedCategories.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_selected_patterns.SelectedPatterns, {
    openInDiscover: openInDiscover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.SelectedField, {
    fields: fields,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlGroup",
    css: _render_custom_toolbar.styles.controlGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlIconButton",
    css: _render_custom_toolbar.styles.controlGroupIconButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_embeddable_menu.EmbeddableMenu, {
    randomSampler: randomSampler,
    reload: () => loadCategories(),
    minimumTimeRangeOption: minimumTimeRangeOption,
    setMinimumTimeRangeOption: setMinimumTimeRangeOption,
    categoryCount: data === null || data === void 0 ? void 0 : data.totalCategories,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 19
    }
  })), selectedField !== null && earliest !== undefined && latest !== undefined ? /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlIconButton",
    css: _render_custom_toolbar.styles.controlGroupIconButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_create_categorization_job.CreateCategorizationJobButton, {
    dataView: dataview,
    field: selectedField,
    query: query,
    earliest: earliest,
    latest: latest,
    iconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 21
    }
  })) : null))))));
};
exports.DiscoverTabs = DiscoverTabs;