"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisParametersFromAlert = exports.getIntervalFactor = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogRateAnalysisParametersFromAlert = ({
  alertStartedAt,
  alertEndedAt,
  timeSize,
  timeUnit
}) => {
  const intervalFactor = getIntervalFactor(timeSize, timeUnit);
  const alertStart = (0, _moment.default)(alertStartedAt);
  const alertEnd = alertEndedAt ? (0, _moment.default)(alertEndedAt) : undefined;
  const helperArgs = {
    alertStart,
    alertEnd,
    intervalFactor
  };
  const timeRange = {
    min: alertStart.clone().subtract(15 * intervalFactor, 'minutes'),
    max: getTimeRangeEnd(helperArgs)
  };
  return {
    timeRange,
    windowParameters: getWindowParameters(helperArgs)
  };
};

// Identify `intervalFactor` to adjust time ranges based on alert settings.
// The default time ranges for `initialAnalysisStart` are suitable for a `1m` lookback.
// If an alert would have a `5m` lookback, this would result in a factor of `5`.
exports.getLogRateAnalysisParametersFromAlert = getLogRateAnalysisParametersFromAlert;
const getIntervalFactor = (timeSize, timeUnit) => {
  const lookbackDuration = timeSize && timeUnit ? _moment.default.duration(timeSize,
  // workaround to cast the string based time unit to moment's format.
  timeUnit) : _moment.default.duration(1, 'm');
  return Math.max(1, lookbackDuration.asSeconds() / 60);
};
exports.getIntervalFactor = getIntervalFactor;
function getTimeRangeEnd({
  alertStart,
  alertEnd,
  intervalFactor
}) {
  if (alertEnd) {
    if (alertStart.clone().add(15 * intervalFactor, 'minutes').isAfter(alertEnd)) return alertEnd.clone().add(1 * intervalFactor, 'minutes');else {
      return alertStart.clone().add(15 * intervalFactor, 'minutes');
    }
  } else if (alertStart.clone().add(15 * intervalFactor, 'minutes').isAfter((0, _moment.default)(new Date()))) {
    return (0, _moment.default)(new Date());
  } else {
    return alertStart.clone().add(15 * intervalFactor, 'minutes');
  }
}
function getDeviationMax({
  alertStart,
  alertEnd,
  intervalFactor
}) {
  if (alertEnd) {
    if (alertStart.clone().add(10 * intervalFactor, 'minutes').isAfter(alertEnd)) return alertEnd.clone().subtract(1 * intervalFactor, 'minutes').valueOf();else {
      return alertStart.clone().add(10 * intervalFactor, 'minutes').valueOf();
    }
  } else if (alertStart.clone().add(10 * intervalFactor, 'minutes').isAfter((0, _moment.default)(new Date()))) {
    return (0, _moment.default)(new Date()).valueOf();
  } else {
    return alertStart.clone().add(10 * intervalFactor, 'minutes').valueOf();
  }
}
function getWindowParameters(args) {
  const {
    alertStart,
    intervalFactor
  } = args;
  return {
    baselineMin: alertStart.clone().subtract(13 * intervalFactor, 'minutes').valueOf(),
    baselineMax: alertStart.clone().subtract(2 * intervalFactor, 'minutes').valueOf(),
    deviationMin: alertStart.clone().subtract(1 * intervalFactor, 'minutes').valueOf(),
    deviationMax: getDeviationMax(args)
  };
}