"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatExperienceSetting = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const chatExperienceSetting = exports.chatExperienceSetting = {
  name: _translations.CHAT_EXPERIENCE_TITLE,
  description: _i18n.i18n.translate('aiAssistantManagementSelection.preferredChatExperienceSettingDescription', {
    defaultMessage: 'Choose which chat experience to use for all users in this space.'
  }),
  schema: _configSchema.schema.oneOf([_configSchema.schema.literal(_aiAssistantCommon.AIChatExperience.Classic), _configSchema.schema.literal(_aiAssistantCommon.AIChatExperience.Agent)], {
    defaultValue: _aiAssistantCommon.AIChatExperience.Classic
  }),
  options: [_aiAssistantCommon.AIChatExperience.Classic, _aiAssistantCommon.AIChatExperience.Agent],
  type: 'select',
  optionLabels: {
    [_aiAssistantCommon.AIChatExperience.Classic]: _translations.CLASSIC_AI_ASSISTANT,
    [_aiAssistantCommon.AIChatExperience.Agent]: _translations.AI_AGENT
  },
  requiresPageReload: true,
  solutionViews: [],
  // Display across all solutions
  // Hide the setting in Kibana -> Advanced Settigns
  readonly: true,
  readonlyMode: 'ui'
};