"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAttachmentTypes = void 0;
var _text = require("./text");
var _esql = require("./esql");
var _screen_context = require("./screen_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAttachmentTypes = ({
  coreSetup,
  setupDeps
}) => {
  const {
    onechat
  } = setupDeps;
  const attachmentTypes = [(0, _text.createTextAttachmentType)(), (0, _screen_context.createScreenContextAttachmentType)(), (0, _esql.createEsqlAttachmentType)()];
  attachmentTypes.forEach(attachmentType => {
    onechat.attachments.registerType(attachmentType);
  });
};
exports.registerAttachmentTypes = registerAttachmentTypes;