"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeRootServiceNodeBindingIfContextFree = removeRootServiceNodeBindingIfContextFree;
const buildPlanBindingConstraintsList_1 = require("../calculations/buildPlanBindingConstraintsList");
const LazyPlanServiceNode_1 = require("../models/LazyPlanServiceNode");
const removeServiceNodeBindingIfContextFree_1 = require("./removeServiceNodeBindingIfContextFree");
/**
 * Detach a binding to the root service node if it is context-free.
 * @param params The plan parameters.
 * @param serviceNode The service node to attach the binding to.
 * @param binding The binding to attach.
 * @returns True if the binding requires ancestor metadata, false otherwise.
 */
function removeRootServiceNodeBindingIfContextFree(params, serviceNode, binding) {
    if (LazyPlanServiceNode_1.LazyPlanServiceNode.is(serviceNode) && !serviceNode.isExpanded()) {
        return {
            bindingNodeRemoved: undefined,
            isContextFreeBinding: true,
        };
    }
    const bindingConstraintsList = (0, buildPlanBindingConstraintsList_1.buildPlanBindingConstraintsList)(params);
    return (0, removeServiceNodeBindingIfContextFree_1.removeServiceNodeBindingIfContextFree)(serviceNode, binding, bindingConstraintsList, params.rootConstraints.isOptional ?? false);
}
//# sourceMappingURL=removeRootServiceNodeBindingIfContextFree.js.map