"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactWindow = require("react-window");
var _services = require("../../../services");
var _auto_sizer = require("../../auto_sizer");
var _highlight = require("../../highlight");
var _mark = require("../../mark");
var _text_truncate = require("../../text_truncate");
var _selectable_list_item = require("./selectable_list_item");
var _selectable_list = require("./selectable_list.styles");
var _react2 = require("@emotion/react");
var _excluded = ["data"],
  _excluded2 = ["label", "isGroupLabel", "checked", "disabled", "prepend", "append", "ref", "key", "searchableLabel", "data", "truncationProps"],
  _excluded3 = ["className", "options", "searchValue", "onOptionClick", "renderOption", "height", "windowProps", "rowHeight", "activeOptionIndex", "makeOptionId", "showIcons", "singleSelection", "visibleOptions", "allowExclusions", "bordered", "paddingSize", "searchable", "onFocusBadge", "listId", "setActiveOptionIndex", "aria-label", "aria-labelledby", "aria-describedby", "role", "isPreFiltered", "isVirtualized", "textWrap", "truncationProps", "autoFocus"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Consumer Configurable Props via `EuiSelectable.listProps`
var EuiSelectableList = exports.EuiSelectableList = /*#__PURE__*/function (_Component) {
  function EuiSelectableList(props) {
    var _this;
    _classCallCheck(this, EuiSelectableList);
    _this = _callSuper(this, EuiSelectableList, [props]);
    _defineProperty(_this, "animationFrameId", void 0);
    // counter for tracking list renders and ensuring rerenders
    _defineProperty(_this, "listRowRerender", 0);
    _defineProperty(_this, "listRef", null);
    _defineProperty(_this, "listBoxRef", null);
    _defineProperty(_this, "setListRef", function (ref) {
      _this.listRef = ref;
      if (ref && _this.props.activeOptionIndex) {
        ref.scrollToItem(_this.props.activeOptionIndex, 'auto');
      }
    });
    _defineProperty(_this, "removeScrollableTabStop", function (ref) {
      // Firefox adds a tab stop for scrollable containers
      // We handle this inside so need to stop firefox from doing its thing
      if (ref) {
        ref.setAttribute('tabindex', '-1');
      }
    });
    _defineProperty(_this, "setListBoxRef", function (ref) {
      _this.listBoxRef = ref;
      var _this$props = _this.props,
        listId = _this$props.listId,
        searchable = _this$props.searchable,
        singleSelection = _this$props.singleSelection,
        autoFocus = _this$props.autoFocus,
        ariaLabel = _this$props['aria-label'],
        ariaLabelledby = _this$props['aria-labelledby'],
        ariaDescribedby = _this$props['aria-describedby'];
      if (ref) {
        ref.setAttribute('id', listId);
        ref.setAttribute('role', 'listbox');
        if (searchable !== true) {
          ref.setAttribute('tabindex', '0');
          if (singleSelection !== 'always' && singleSelection !== true) {
            ref.setAttribute('aria-multiselectable', 'true');
          }
        }
        if (typeof ariaLabel === 'string') {
          ref.setAttribute('aria-label', ariaLabel);
        } else if (typeof ariaLabelledby === 'string') {
          ref.setAttribute('aria-labelledby', ariaLabelledby);
        }
        if (typeof ariaDescribedby === 'string') {
          ref.setAttribute('aria-describedby', ariaDescribedby);
        }
        if (autoFocus === true) {
          // manually focus listbox once available
          // use last stack execution to prevent potential focus order issues
          setTimeout(function () {
            return ref.focus();
          });
        }
      }
    });
    // This utility is necessary to exclude group labels from the aria set count
    _defineProperty(_this, "calculateAriaSetAttrs", function (optionArray) {
      var ariaPosInSetMap = {};
      var latestAriaPosIndex = 0;
      optionArray.forEach(function (option, index) {
        if (!option.isGroupLabel) {
          latestAriaPosIndex++;
          ariaPosInSetMap[index] = latestAriaPosIndex;
        }
      });
      return {
        ariaPosInSetMap: ariaPosInSetMap,
        ariaSetSize: latestAriaPosIndex
      };
    });
    _defineProperty(_this, "ListRow", /*#__PURE__*/(0, _react.memo)(function (_ref) {
      var _option$textWrap;
      var data = _ref.data,
        index = _ref.index,
        style = _ref.style;
      var option = data[index];
      var optionData = option.data,
        _option = _objectWithoutProperties(option, _excluded);
      var label = option.label,
        isGroupLabel = option.isGroupLabel,
        checked = option.checked,
        disabled = option.disabled,
        prepend = option.prepend,
        append = option.append,
        ref = option.ref,
        key = option.key,
        searchableLabel = option.searchableLabel,
        _data = option.data,
        _truncationProps = option.truncationProps,
        optionRest = _objectWithoutProperties(option, _excluded2);
      var _this$props2 = _this.props,
        activeOptionIndex = _this$props2.activeOptionIndex,
        allowExclusions = _this$props2.allowExclusions,
        onFocusBadge = _this$props2.onFocusBadge,
        paddingSize = _this$props2.paddingSize,
        showIcons = _this$props2.showIcons,
        makeOptionId = _this$props2.makeOptionId,
        renderOption = _this$props2.renderOption,
        setActiveOptionIndex = _this$props2.setActiveOptionIndex,
        searchable = _this$props2.searchable,
        searchValue = _this$props2.searchValue,
        isPreFiltered = _this$props2.isPreFiltered,
        isVirtualized = _this$props2.isVirtualized;
      if (isGroupLabel) {
        return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
          var styles = stylesMemoizer(_selectable_list.euiSelectableListStyles);
          return (0, _react2.jsx)("li", _extends({
            role: "presentation",
            css: styles.euiSelectableList__groupLabel,
            className: "euiSelectableList__groupLabel",
            style: style
          }, optionRest), prepend, label, append);
        });
      }
      var id = makeOptionId(index);
      var isFocused = activeOptionIndex === index;

      // Search highlighting
      var hasSearch = !!searchValue;
      var highlightSearch = hasSearch && (_typeof(isPreFiltered) === 'object' ? isPreFiltered.highlightSearch !== false : true);

      // Text wrapping
      var canWrap = !isVirtualized;
      var _textWrap = (_option$textWrap = option.textWrap) !== null && _option$textWrap !== void 0 ? _option$textWrap : _this.props.textWrap;
      var textWrap = canWrap ? _textWrap : 'truncate';

      // Truncation config (if any). If none, CSS truncation is used
      var truncationProps = textWrap === 'truncate' ? _this.getTruncationProps(option, highlightSearch, isFocused) : undefined;
      return (0, _react2.jsx)(_selectable_list_item.EuiSelectableListItem, _extends({
        key: id,
        id: id,
        style: style,
        onMouseDown: function onMouseDown() {
          setActiveOptionIndex(index);
        },
        onClick: function onClick(event) {
          event.persist(); // NOTE: This is needed for React v16 backwards compatibility
          _this.onAddOrRemoveOption(option, event);
        },
        isFocused: isFocused,
        title: searchableLabel || label,
        checked: checked,
        disabled: disabled,
        prepend: prepend,
        append: append,
        "aria-posinset": _this.state.ariaPosInSetMap[index],
        "aria-setsize": _this.state.ariaSetSize,
        onFocusBadge: onFocusBadge,
        allowExclusions: allowExclusions,
        showIcons: showIcons,
        paddingSize: paddingSize,
        searchable: searchable,
        textWrap: textWrap
        // @ts-ignore complex
      }, optionRest), renderOption ? renderOption( // @ts-ignore complex
      _objectSpread(_objectSpread({}, _option), optionData), searchValue) : highlightSearch ? _this.renderSearchedText(label, truncationProps) : truncationProps ? _this.renderTruncatedText(label, truncationProps) : label);
    }, _reactWindow.areEqual));
    _defineProperty(_this, "renderVirtualizedList", function (listClasses) {
      if (!_this.props.isVirtualized) return null;
      var _this$state = _this.state,
        optionArray = _this$state.optionArray,
        itemData = _this$state.itemData;
      var _this$props3 = _this.props,
        windowProps = _this$props3.windowProps,
        forcedHeight = _this$props3.height,
        rowHeight = _this$props3.rowHeight;
      var heightIsFull = forcedHeight === 'full';
      var virtualizationProps = _objectSpread({
        className: listClasses,
        ref: _this.setListRef,
        outerRef: _this.removeScrollableTabStop,
        innerRef: _this.setListBoxRef,
        innerElementType: 'ul',
        itemCount: optionArray.length,
        itemData: itemData,
        itemSize: rowHeight,
        'data-skip-axe': 'scrollable-region-focusable'
      }, windowProps);

      // Calculated height is only used if height is not full
      var calculatedHeight = !heightIsFull ? forcedHeight || 0 : 0;

      // If calculatedHeight is still falsy, then calculate it
      if (!heightIsFull && !calculatedHeight) {
        var maxVisibleOptions = 7;
        var numVisibleOptions = optionArray.length;
        var numVisibleMoreThanMax = optionArray.length > maxVisibleOptions;
        if (numVisibleMoreThanMax) {
          // Show only half of the last one to indicate there's more to scroll to
          calculatedHeight = (maxVisibleOptions - 0.5) * rowHeight;
        } else {
          calculatedHeight = numVisibleOptions * rowHeight;
        }
      }
      return heightIsFull ? (0, _react2.jsx)(_auto_sizer.EuiAutoSizer, {
        onResize: _this.calculateDefaultOptionWidth
      }, function (_ref2) {
        var width = _ref2.width,
          height = _ref2.height;
        return (0, _react2.jsx)(_reactWindow.FixedSizeList, _extends({
          width: width,
          height: height
        }, virtualizationProps), _this.ListRow);
      }) : (0, _react2.jsx)(_auto_sizer.EuiAutoSizer, {
        disableHeight: true,
        onResize: _this.calculateDefaultOptionWidth
      }, function (_ref3) {
        var width = _ref3.width;
        return (0, _react2.jsx)(_reactWindow.FixedSizeList, _extends({
          width: width,
          height: calculatedHeight
        }, virtualizationProps), _this.ListRow);
      });
    });
    _defineProperty(_this, "forceVirtualizedListRowRerender", function () {
      _this.setState({
        itemData: _objectSpread({}, _this.state.optionArray)
      });
    });
    // EuiTextTruncate is expensive perf-wise - we use several utilities here to
    // offset its performance cost
    // and creates a resize observer for
    // each individual item. This logic tries to offset this performance hit by
    // guesstimating a default width for each option
    _defineProperty(_this, "focusBadgeOffset", 0);
    _defineProperty(_this, "calculateDefaultOptionWidth", function (_ref4) {
      var containerWidth = _ref4.width;
      var _this$props4 = _this.props,
        truncationProps = _this$props4.truncationProps,
        searchable = _this$props4.searchable,
        searchValue = _this$props4.searchValue;

      // If it's not likely we'll need to use EuiTextTruncate, don't set state/rerender on every panel resize
      var mayTruncate = searchable || truncationProps;
      if (!mayTruncate) return;
      var paddingOffset = _this.props.paddingSize === 'none' ? 0 : 24; // Defaults to 's'
      var checkedIconOffset = _this.props.showIcons === false ? 0 : 28; // Defaults to true
      _this.focusBadgeOffset = _this.props.onFocusBadge === false ? 0 : 46;

      // Wait a tick for the listbox ref to update before proceeding
      _this.animationFrameId = requestAnimationFrame(function () {
        var scrollbarOffset = _this.listBoxRef ? containerWidth - _this.listBoxRef.offsetWidth : 0;
        _this.setState({
          defaultOptionWidth: containerWidth - scrollbarOffset - paddingOffset - checkedIconOffset
        });

        // Potentially force list rows to rerender on dynamic resize as well,
        // but try to do it as lightly as possible
        if (truncationProps || searchable && searchValue) {
          _this.forceVirtualizedListRowRerender();
        }
      });
    });
    _defineProperty(_this, "getTruncationProps", function (option, highlightSearch, isFocused) {
      // Individual truncation settings should override component-wide settings
      var truncationProps = _objectSpread(_objectSpread({}, _this.props.truncationProps), option.truncationProps);

      // If we're not actually using EuiTextTruncate, no need to continue
      var hasComplexTruncation = highlightSearch || Object.keys(truncationProps).length > 0;
      if (!hasComplexTruncation) return undefined;

      // Determine whether we can use the optimized default option width
      var defaultOptionWidth = _this.state.defaultOptionWidth;
      var useDefaultWidth = !option.append && !option.prepend;
      var defaultWidth = useDefaultWidth && defaultOptionWidth ? isFocused ? defaultOptionWidth - _this.focusBadgeOffset : defaultOptionWidth : undefined;
      return _objectSpread({
        width: defaultWidth
      }, truncationProps);
    });
    _defineProperty(_this, "renderSearchedText", function (text, truncationProps) {
      var searchValue = _this.props.searchValue;

      // If truncationProps is undefined, we're using non-virtualized text wrapping
      if (!truncationProps) {
        return (0, _react2.jsx)(_highlight.EuiHighlight, {
          search: searchValue
        }, text);
      }
      var searchPositionStart = text.toLowerCase().indexOf(searchValue.toLowerCase());
      var searchPositionCenter = searchPositionStart + Math.floor(searchValue.length / 2);
      return (0, _react2.jsx)(_text_truncate.EuiTextTruncate, _extends({}, truncationProps, {
        // When searching, don't allow overriding the truncation settings
        truncation: "startEnd",
        truncationPosition: searchPositionCenter,
        text: text
      }), function (text) {
        return (0, _react2.jsx)(_react.default.Fragment, null, text.length >= searchValue.length ? (0, _react2.jsx)(_highlight.EuiHighlight, {
          search: searchValue
        }, text) :
        // If the available truncated text is shorter than the full search string,
        // just highlight the entire truncated text
        (0, _react2.jsx)(_mark.EuiMark, null, text));
      });
    });
    _defineProperty(_this, "renderTruncatedText", function (text, truncationProps) {
      return (
        // For some bizarre reason, truncation in EuiSelectable is off on initial mount
        // (but not on rerender) for Safari and _some_ truncation types in Firefox :|
        // Waiting a tick before calculating truncation seems to smooth over the issue
        (0, _react2.jsx)(_text_truncate.EuiTextTruncate, _extends({
          calculationDelayMs: 2
        }, truncationProps, {
          text: text
        }), function (text) {
          return text;
        })
      );
    });
    _defineProperty(_this, "onAddOrRemoveOption", function (option, event) {
      if (option.disabled) {
        return;
      }
      var _this$props5 = _this.props,
        allowExclusions = _this$props5.allowExclusions,
        options = _this$props5.options,
        _this$props5$visibleO = _this$props5.visibleOptions,
        visibleOptions = _this$props5$visibleO === void 0 ? options : _this$props5$visibleO;
      _this.props.setActiveOptionIndex(visibleOptions.findIndex(function (_ref5) {
        var label = _ref5.label;
        return label === option.label;
      }), function () {
        if (option.checked === 'on' && allowExclusions) {
          _this.onExcludeOption(option, event);
        } else if (option.checked === 'on' || option.checked === 'off') {
          _this.onRemoveOption(option, event);
        } else {
          _this.onAddOption(option, event);
        }
      });
    });
    _defineProperty(_this, "onAddOption", function (addedOption, event) {
      var _this$props6 = _this.props,
        onOptionClick = _this$props6.onOptionClick,
        options = _this$props6.options,
        singleSelection = _this$props6.singleSelection;
      var changedOption = _objectSpread({}, addedOption);
      var updatedOptions = options.map(function (option) {
        // if singleSelection is enabled, uncheck any selected option(s)
        var updatedOption = _objectSpread({}, option);
        if (singleSelection) {
          delete updatedOption.checked;
        }

        // if this is the now-selected option, check it
        if (option === addedOption) {
          updatedOption.checked = 'on';
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    _defineProperty(_this, "onRemoveOption", function (removedOption, event) {
      var _this$props7 = _this.props,
        onOptionClick = _this$props7.onOptionClick,
        singleSelection = _this$props7.singleSelection,
        options = _this$props7.options;
      var changedOption = _objectSpread({}, removedOption);
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);
        if (option === removedOption && singleSelection !== 'always') {
          delete updatedOption.checked;
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    _defineProperty(_this, "onExcludeOption", function (excludedOption, event) {
      var _this$props8 = _this.props,
        onOptionClick = _this$props8.onOptionClick,
        options = _this$props8.options;
      var changedOption = _objectSpread({}, excludedOption);
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);
        if (option === excludedOption) {
          updatedOption.checked = 'off';
          changedOption = updatedOption;
        }
        return updatedOption;
      });
      onOptionClick(updatedOptions, event, changedOption);
    });
    var _optionArray = props.visibleOptions || props.options;
    _this.state = _objectSpread({
      defaultOptionWidth: 0,
      optionArray: _optionArray,
      itemData: _objectSpread({}, _optionArray)
    }, _this.calculateAriaSetAttrs(_optionArray));
    return _this;
  }
  _inherits(EuiSelectableList, _Component);
  return _createClass(EuiSelectableList, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      // ensure requestAnimationFrame is canceled on unmount as
      // it could potentially run on a next tick otherwise
      if (this.animationFrameId !== undefined) {
        cancelAnimationFrame(this.animationFrameId);
        this.animationFrameId = undefined;
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      var _this$props9 = this.props,
        allowExclusions = _this$props9.allowExclusions,
        showIcons = _this$props9.showIcons,
        paddingSize = _this$props9.paddingSize,
        textWrap = _this$props9.textWrap,
        onFocusBadge = _this$props9.onFocusBadge,
        searchable = _this$props9.searchable;

      // using shouldComponentUpdate to determine needed rerender before actual rerender
      // without needing state updates or lagging behind on updates
      if (nextProps.allowExclusions !== allowExclusions || nextProps.showIcons !== showIcons || nextProps.paddingSize !== paddingSize || nextProps.textWrap !== textWrap || nextProps.onFocusBadge !== onFocusBadge || nextProps.searchable !== searchable) {
        this.listRowRerender += 1;
      }
      return true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props10 = this.props,
        isVirtualized = _this$props10.isVirtualized,
        activeOptionIndex = _this$props10.activeOptionIndex,
        visibleOptions = _this$props10.visibleOptions,
        options = _this$props10.options,
        allowExclusions = _this$props10.allowExclusions,
        showIcons = _this$props10.showIcons,
        paddingSize = _this$props10.paddingSize,
        textWrap = _this$props10.textWrap,
        onFocusBadge = _this$props10.onFocusBadge,
        searchable = _this$props10.searchable;
      if (prevProps.activeOptionIndex !== activeOptionIndex) {
        var makeOptionId = this.props.makeOptionId;
        if (this.listBoxRef && this.props.searchable !== true) {
          this.listBoxRef.setAttribute('aria-activedescendant', makeOptionId(activeOptionIndex));
        }
        if (typeof activeOptionIndex !== 'undefined') {
          if (isVirtualized) {
            var _this$listRef;
            (_this$listRef = this.listRef) === null || _this$listRef === void 0 || _this$listRef.scrollToItem(activeOptionIndex, 'auto');
          } else {
            var _this$listBoxRef;
            var activeOptionId = "#".concat(makeOptionId(activeOptionIndex));
            var activeOptionEl = (_this$listBoxRef = this.listBoxRef) === null || _this$listBoxRef === void 0 ? void 0 : _this$listBoxRef.querySelector(activeOptionId);
            if (activeOptionEl) {
              var _activeOptionEl$scrol;
              // TODO: we can remove scrollIntoView's conditional chaining once jsdom stubs it
              // @see https://github.com/jsdom/jsdom/issues/1695
              (_activeOptionEl$scrol = activeOptionEl.scrollIntoView) === null || _activeOptionEl$scrol === void 0 || _activeOptionEl$scrol.call(activeOptionEl, {
                block: 'nearest'
              });
            }
          }
        }
      }
      var optionArray = visibleOptions || options;
      if (prevProps.visibleOptions !== visibleOptions || prevProps.options !== options) {
        this.setState(_objectSpread({
          optionArray: optionArray,
          itemData: _objectSpread({}, optionArray)
        }, this.calculateAriaSetAttrs(optionArray)));
      } else if (isVirtualized) {
        // ensure that ListRow updates based on item props
        if (prevProps.allowExclusions !== allowExclusions || prevProps.showIcons !== showIcons || prevProps.paddingSize !== paddingSize || prevProps.textWrap !== textWrap || prevProps.onFocusBadge !== onFocusBadge || prevProps.searchable !== searchable) {
          this.setState({
            itemData: _objectSpread({}, optionArray)
          });
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props11 = this.props,
        className = _this$props11.className,
        options = _this$props11.options,
        searchValue = _this$props11.searchValue,
        onOptionClick = _this$props11.onOptionClick,
        renderOption = _this$props11.renderOption,
        forcedHeight = _this$props11.height,
        windowProps = _this$props11.windowProps,
        rowHeight = _this$props11.rowHeight,
        activeOptionIndex = _this$props11.activeOptionIndex,
        makeOptionId = _this$props11.makeOptionId,
        showIcons = _this$props11.showIcons,
        singleSelection = _this$props11.singleSelection,
        visibleOptions = _this$props11.visibleOptions,
        allowExclusions = _this$props11.allowExclusions,
        bordered = _this$props11.bordered,
        paddingSize = _this$props11.paddingSize,
        searchable = _this$props11.searchable,
        onFocusBadge = _this$props11.onFocusBadge,
        listId = _this$props11.listId,
        setActiveOptionIndex = _this$props11.setActiveOptionIndex,
        ariaLabel = _this$props11['aria-label'],
        ariaLabelledby = _this$props11['aria-labelledby'],
        ariaDescribedby = _this$props11['aria-describedby'],
        role = _this$props11.role,
        isPreFiltered = _this$props11.isPreFiltered,
        isVirtualized = _this$props11.isVirtualized,
        textWrap = _this$props11.textWrap,
        truncationProps = _this$props11.truncationProps,
        autoFocus = _this$props11.autoFocus,
        rest = _objectWithoutProperties(_this$props11, _excluded3);
      var heightIsFull = forcedHeight === 'full';
      var classes = (0, _classnames.default)('euiSelectableList', className);
      return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(_selectable_list.euiSelectableListStyles);
        var cssStyles = [styles.euiSelectableList, heightIsFull && styles.fullHeight, bordered && styles.bordered];
        var listClasses = (0, _classnames.default)('euiSelectableList__list', styles.euiSelectableList__list);
        return (0, _react2.jsx)("div", _extends({
          css: cssStyles,
          className: classes
        }, rest), isVirtualized ? _this2.renderVirtualizedList(listClasses) : (0, _react2.jsx)("div", {
          className: listClasses,
          style: !heightIsFull ? {
            blockSize: forcedHeight
          } : undefined,
          ref: _this2.removeScrollableTabStop
        }, (0, _react2.jsx)("ul", {
          ref: _this2.setListBoxRef
        }, _this2.state.optionArray.map(function (_, index) {
          return /*#__PURE__*/_react.default.createElement(_this2.ListRow, {
            key: "".concat(index, "-").concat(_this2.listRowRerender),
            data: _this2.state.optionArray,
            index: index
          }, null);
        }))));
      });
    }
  }]);
}(_react.Component);
_defineProperty(EuiSelectableList, "defaultProps", {
  rowHeight: 32,
  searchValue: '',
  isVirtualized: true
});
EuiSelectableList.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * The index of the option to be highlighted as pseudo-focused;
       * Good for use when only one selection is allowed and needing to open
       * directly to that option
       */
  activeOptionIndex: _propTypes.default.number,
  /**
       * Show the check/cross selection indicator icons
       */
  showIcons: _propTypes.default.bool,
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.oneOf(["always"]), _propTypes.default.bool.isRequired]),
  /**
       * Any props to send specifically to the react-window `FixedSizeList`
       */
  windowProps: _propTypes.default.any,
  /**
       * Adds a border around the list to indicate the bounds;
       * Useful when the list scrolls, otherwise use your own container
       */
  bordered: _propTypes.default.bool,
  /**
       * When enabled by setting to either `true` or passing custom text,
       * shows a hollow badge as an append (far right) when the item is focused.
       * The default content when `true` is `↩ to select/deselect/include/exclude`
       */
  onFocusBadge: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    /**
       * Accepts any string from our icon library
       */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "backgroundTask", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "streamsClassic", "streamsWired", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "thumbDown", "thumbUp", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workflowsApp", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    /**
       * The side of the badge the icon should sit
       */
    iconSide: _propTypes.default.any,
    /**
       * Accepts either our palette colors (primary, success ..etc) or a hex value `#FFFFFF`, `#000`.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
    /**
       * Will override any color passed through the `color` prop.
       */
    isDisabled: _propTypes.default.bool,
    /**
       * Props passed to the close button.
       */
    closeButtonProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Will apply an onclick to icon within the badge
       */
    iconOnClick: _propTypes.default.func,
    /**
       * Aria label applied to the iconOnClick button
       */
    iconOnClickAriaLabel: _propTypes.default.any,
    /**
       * Will apply an onclick to the badge itself
       */
    onClick: _propTypes.default.func,
    /**
       * Aria label applied to the onClick button
       */
    onClickAriaLabel: _propTypes.default.any,
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string
  }).isRequired]),
  /**
       * Padding for the list items.
       */
  paddingSize: _propTypes.default.any,
  /**
       * How to handle long text within the item.
       * Wrapping only works if virtualization is off.
       */
  textWrap: _propTypes.default.oneOf(["truncate", "wrap"]),
  /**
       * If textWrap is set to `truncate`, you can pass a custom truncation configuration
       * that accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop except for
       * `text` and `children`.
       *
       * Note: when searching, custom truncation props are ignored. The highlighted search
       * text will always take precedence.
       */
  truncationProps: _propTypes.default.any,
  /**
       * Use virtualized rendering for list items with `react-window`.
       * Sets each row's height to the value of `rowHeight`.
       */
  isVirtualized: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]), _propTypes.default.oneOf([false]).isRequired]),
  /**
       *  The height of each option in pixels. Defaults to `32`.
       *  Has no effect if `isVirtualized=false`.
       */
  rowHeight: _propTypes.default.number,
  /**
     * All possible options
     */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: _propTypes.default.string,
    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: _propTypes.default.string,
    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: _propTypes.default.string,
    /**
       * Leave `undefined` to indicate not selected. Pass a string of
       * 'on' to indicate inclusion, 'off' to indicate exclusion,
       * or 'mixed' to indicate inclusion for some.
       */
    checked: _propTypes.default.any,
    disabled: _propTypes.default.bool,
    /**
       * Node to add between the selection icon and the label
       */
    prepend: _propTypes.default.node,
    /**
       * Node to add to the far right of the item
       */
    append: _propTypes.default.node,
    ref: _propTypes.default.func,
    /**
       * Option data to pass through to the `renderOptions` element.
       * Bypass `EuiSelectableItem` and avoid DOM attribute warnings.
       */
    data: _propTypes.default.shape({}),
    /**
       * How to handle long text within the item.
       * Wrapping only works if `isVirtualization` is false.
       * @default 'truncate'
       */
    textWrap: _propTypes.default.oneOf(["truncate", "wrap"]),
    /**
       * If textWrap is set to `truncate`, you can pass a custom truncation configuration
       * that accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop except for
       * `text` and `children`.
       *
       * Note: when searching, custom truncation props are ignored. The highlighted search
       * text will always take precedence.
       */
    truncationProps: _propTypes.default.any,
    /**
       * Optional custom tooltip content for the button
       */
    toolTipContent: _propTypes.default.node,
    /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
    toolTipProps: _propTypes.default.any
  }).isRequired).isRequired,
  /**
     * Filtered options list (if applicable)
     */
  visibleOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    label: _propTypes.default.string,
    searchableLabel: _propTypes.default.string,
    key: _propTypes.default.string,
    checked: _propTypes.default.any,
    disabled: _propTypes.default.bool,
    prepend: _propTypes.default.node,
    append: _propTypes.default.node,
    ref: _propTypes.default.func,
    data: _propTypes.default.shape({}),
    textWrap: _propTypes.default.oneOf(["truncate", "wrap"]),
    truncationProps: _propTypes.default.any,
    toolTipContent: _propTypes.default.node,
    toolTipProps: _propTypes.default.any
  }).isRequired),
  /**
     * Search value to highlight on the option render
     */
  searchValue: _propTypes.default.string.isRequired,
  /**
     * Returns the array of options with altered checked state, the click/keyboard event,
     * and the option that triggered the click/keyboard event
     */
  onOptionClick: _propTypes.default.func.isRequired,
  /**
     * Custom render for the label portion of the option;
     * Takes (option, searchValue), returns ReactNode
     */
  renderOption: _propTypes.default.func,
  /**
     * Sets the max height in pixels or pass `full` to allow
     * the whole group to fill the height of its container and
     * allows the list grow as well
     */
  height: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf(["full"])]),
  /**
     * Allow cycling through the on, off and undefined state of option.checked
     * and not just on and undefined
     */
  allowExclusions: _propTypes.default.bool,
  searchable: _propTypes.default.bool,
  isPreFiltered: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    highlightSearch: _propTypes.default.bool
  }).isRequired]),
  makeOptionId: _propTypes.default.func.isRequired,
  listId: _propTypes.default.string.isRequired,
  setActiveOptionIndex: _propTypes.default.func.isRequired
};