"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSession = exports.usePushPaddingOffsets = exports.useParentFlyoutSize = exports.useIsFlyoutRegistered = exports.useIsFlyoutActive = exports.useHasPushPadding = exports.useHasChildFlyout = exports.useHasActiveSession = exports.useFlyoutWidth = exports.useFlyout = exports.useCurrentSession = exports.useCurrentMainFlyout = exports.useCurrentFlyoutZIndexRef = exports.useCurrentChildFlyout = void 0;
var _provider = require("./provider");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var useSession = exports.useSession = function useSession(flyoutId) {
  var context = (0, _provider.useFlyoutManager)();
  if (!context) {
    return null;
  }
  return context.state.sessions.find(function (s) {
    return s.mainFlyoutId === flyoutId || s.childFlyoutId === flyoutId;
  }) || null;
};

/** True when any managed flyout session is currently active. */
var useHasActiveSession = exports.useHasActiveSession = function useHasActiveSession() {
  return !!useCurrentSession();
};

/** True if the given `flyoutId` is the main or child flyout in the latest session. */
var useIsFlyoutActive = exports.useIsFlyoutActive = function useIsFlyoutActive(flyoutId) {
  var currentSession = useCurrentSession();
  return (currentSession === null || currentSession === void 0 ? void 0 : currentSession.mainFlyoutId) === flyoutId || (currentSession === null || currentSession === void 0 ? void 0 : currentSession.childFlyoutId) === flyoutId;
};
var useFlyout = exports.useFlyout = function useFlyout(flyoutId) {
  var context = (0, _provider.useFlyoutManager)();
  if (!context || !flyoutId) {
    return null;
  }
  return context.state.flyouts.find(function (f) {
    return f.flyoutId === flyoutId;
  }) || null;
};
var useIsFlyoutRegistered = exports.useIsFlyoutRegistered = function useIsFlyoutRegistered(flyoutId) {
  var context = (0, _provider.useFlyoutManager)();
  if (!context || !flyoutId) {
    return false;
  }
  return context.state.flyouts.some(function (f) {
    return f.flyoutId === flyoutId;
  });
};

/** The most recent flyout session or `null` if none. */
var useCurrentSession = exports.useCurrentSession = function useCurrentSession() {
  var context = (0, _provider.useFlyoutManager)();
  if (!context) return null;
  return context.state.sessions[context.state.sessions.length - 1] || null;
};

/** The registered state of the current session's main flyout, if present. */
var useCurrentMainFlyout = exports.useCurrentMainFlyout = function useCurrentMainFlyout() {
  var currentSession = useCurrentSession();
  var mainFlyoutId = currentSession === null || currentSession === void 0 ? void 0 : currentSession.mainFlyoutId;
  return useFlyout(mainFlyoutId);
};

/** The registered state of the current session's child flyout, if present. */
var useCurrentChildFlyout = exports.useCurrentChildFlyout = function useCurrentChildFlyout() {
  var currentSession = useCurrentSession();
  var childFlyoutId = currentSession === null || currentSession === void 0 ? void 0 : currentSession.childFlyoutId;
  return useFlyout(childFlyoutId);
};

/** The measured width (px) of the specified flyout, or `null` if unknown. */
var useFlyoutWidth = exports.useFlyoutWidth = function useFlyoutWidth(flyoutId) {
  var _useFlyout;
  return (_useFlyout = useFlyout(flyoutId)) === null || _useFlyout === void 0 ? void 0 : _useFlyout.width;
};

/** The configured size of the parent (main) flyout for a given child flyout ID. */
var useParentFlyoutSize = exports.useParentFlyoutSize = function useParentFlyoutSize(childFlyoutId) {
  var session = useSession(childFlyoutId);
  var parentFlyout = useFlyout(session === null || session === void 0 ? void 0 : session.mainFlyoutId);
  return parentFlyout === null || parentFlyout === void 0 ? void 0 : parentFlyout.size;
};

/** True if the provided `flyoutId` is the main flyout and it currently has a child. */
var useHasChildFlyout = exports.useHasChildFlyout = function useHasChildFlyout(flyoutId) {
  var session = useSession(flyoutId);
  return !!(session !== null && session !== void 0 && session.childFlyoutId);
};

/** Get the current push padding offsets from manager state. */
var usePushPaddingOffsets = exports.usePushPaddingOffsets = function usePushPaddingOffsets() {
  var _context$state$pushPa;
  var context = (0, _provider.useFlyoutManager)();
  if (!context) {
    return {
      left: 0,
      right: 0
    };
  }
  return (_context$state$pushPa = context.state.pushPadding) !== null && _context$state$pushPa !== void 0 ? _context$state$pushPa : {
    left: 0,
    right: 0
  };
};

/** True if there's any active push padding (left or right side). */
var useHasPushPadding = exports.useHasPushPadding = function useHasPushPadding() {
  var pushPadding = usePushPaddingOffsets();
  return pushPadding.left > 0 || pushPadding.right > 0;
};

/** Get the ref for the current flyout z-index to be used */
var useCurrentFlyoutZIndexRef = exports.useCurrentFlyoutZIndexRef = function useCurrentFlyoutZIndexRef() {
  var context = (0, _provider.useFlyoutManager)();
  return (0, _react.useRef)((context === null || context === void 0 ? void 0 : context.state.currentZIndex) || 0);
};