"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutMain = EuiFlyoutMain;
var _react = _interopRequireDefault(require("react"));
var _flyout_managed = require("./flyout_managed");
var _hooks = require("./hooks");
var _flyout_main = require("./flyout_main.styles");
var _services = require("../../../services");
var _const = require("../const");
var _hooks2 = require("../hooks");
var _const2 = require("./const");
var _react2 = require("@emotion/react");
var _excluded = ["id", "pushMinBreakpoint", "type", "side"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Props for `EuiFlyoutMain`, the primary managed flyout component.
 * The `level` prop is fixed internally to `main` and is therefore omitted.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * Managed main flyout. Handles ID management, child-flyout styling,
 * and push/overlay behavior based on provided props.
 */
function EuiFlyoutMain(_ref) {
  var id = _ref.id,
    _ref$pushMinBreakpoin = _ref.pushMinBreakpoint,
    pushMinBreakpoint = _ref$pushMinBreakpoin === void 0 ? _const.DEFAULT_PUSH_MIN_BREAKPOINT : _ref$pushMinBreakpoin,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? _const.DEFAULT_TYPE : _ref$type,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? _const.DEFAULT_SIDE : _ref$side,
    props = _objectWithoutProperties(_ref, _excluded);
  var flyoutId = (0, _hooks.useFlyoutId)(id);
  var hasChildFlyout = (0, _hooks.useHasChildFlyout)(flyoutId);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_main.euiMainFlyoutStyles);
  var isPushed = (0, _hooks2.useIsPushed)({
    type: type,
    pushMinBreakpoint: pushMinBreakpoint
  });
  var cssStyles = [hasChildFlyout && !isPushed && styles.hasChildFlyout[side]];
  var style = {};
  return (0, _react2.jsx)(_flyout_managed.EuiManagedFlyout, _extends({
    id: flyoutId,
    level: _const2.LEVEL_MAIN,
    style: style,
    css: cssStyles
  }, _objectSpread(_objectSpread({}, props), {}, {
    pushMinBreakpoint: pushMinBreakpoint,
    type: type,
    side: side
  })));
}