"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAbsoluteTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _form = require("../../../form");
var _flex = require("../../../flex");
var _button = require("../../../button");
var _code = require("../../../code");
var _date_picker = require("../../date_picker");
var _timezone_display = require("./timezone_display");
var _absolute_tab = require("./absolute_tab.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Allow users to paste in and have the datepicker parse multiple common date formats,
// in addition to the configured displayed `dateFormat` prop
var ALLOWED_USER_DATE_FORMATS = [_moment.default.ISO_8601, _moment.default.RFC_2822, 'X' // Unix timestamp in seconds
];
var EuiAbsoluteTab = exports.EuiAbsoluteTab = function EuiAbsoluteTab(_ref) {
  var value = _ref.value,
    onChange = _ref.onChange,
    dateFormat = _ref.dateFormat,
    timeFormat = _ref.timeFormat,
    locale = _ref.locale,
    roundUp = _ref.roundUp,
    utcOffset = _ref.utcOffset,
    minDate = _ref.minDate,
    maxDate = _ref.maxDate,
    labelPrefix = _ref.labelPrefix,
    _ref$timeZoneDisplayP = _ref.timeZoneDisplayProps,
    timeZoneDisplayProps = _ref$timeZoneDisplayP === void 0 ? {} : _ref$timeZoneDisplayP;
  var styles = (0, _services.useEuiMemoizedStyles)(_absolute_tab.euiAbsoluteTabDateFormStyles);
  var _useState = (0, _react.useState)(function () {
      var parsedValue = _datemath.default.parse(value, {
        roundUp: roundUp
      });
      return parsedValue && parsedValue.isValid() ? parsedValue : (0, _moment.default)();
    }),
    _useState2 = _slicedToArray(_useState, 2),
    valueAsMoment = _useState2[0],
    setValueAsMoment = _useState2[1];
  var handleChange = (0, _react.useCallback)(function (date) {
    if (date === null) return;
    var valueAsMoment = (0, _moment.default)(date);
    setValueAsMoment(valueAsMoment);
    setTextInputValue(valueAsMoment.format(dateFormat));
    setHasUnparsedText(false);
    setIsTextInvalid(false);
  }, [dateFormat]);
  var textInputLabelId = (0, _services.useGeneratedHtmlId)();
  var timeZomeDescriptionId = (0, _services.useGeneratedHtmlId)();
  var submitButtonLabel = (0, _i18n.useEuiI18n)('euiAbsoluteTab.dateFormatButtonLabel', 'Parse date');
  var dateFormatError = (0, _i18n.useEuiI18n)('euiAbsoluteTab.dateFormatError', 'Allowed formats: {dateFormat}, ISO 8601, RFC 2822, or Unix timestamp.', {
    dateFormat: (0, _react2.jsx)(_code.EuiCode, null, dateFormat)
  });
  var _useState3 = (0, _react.useState)(function () {
      return valueAsMoment.locale(locale || 'en').format(dateFormat);
    }),
    _useState4 = _slicedToArray(_useState3, 2),
    textInputValue = _useState4[0],
    setTextInputValue = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    hasUnparsedText = _useState6[0],
    setHasUnparsedText = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isReadyToParse = _useState8[0],
    setIsReadyToParse = _useState8[1];
  var _useState9 = (0, _react.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    isTextInvalid = _useState10[0],
    setIsTextInvalid = _useState10[1];
  var handleTextChange = (0, _react.useCallback)(function (event) {
    if (isReadyToParse) return; // Text paste event, don't continue

    setTextInputValue(event.target.value);
    setHasUnparsedText(true);
    setIsTextInvalid(false);
  }, [isReadyToParse]);
  (0, _react.useEffect)(function () {
    if (isReadyToParse) {
      if (!textInputValue) {
        setIsTextInvalid(true);
        setValueAsMoment(null);
        return;
      }

      // We can be forgiving for `dateFormat` if we are certain
      // we're not expecting any of the other formats allowed;
      // otherwise we can get valid but inaccurate results e.g.
      // `1970-01-01` -> `Jan 19, 1970 @ 01:01:00.000`
      var strictModeForPassedFormat = (0, _moment.default)(textInputValue, ALLOWED_USER_DATE_FORMATS, true).isValid();

      // Attempt to parse with passed `dateFormat` and `locale`
      var _valueAsMoment = (0, _moment.default)(textInputValue, dateFormat, typeof locale === 'string' ? locale : 'en',
      // Narrow the union type to string
      strictModeForPassedFormat);
      var dateIsValid = _valueAsMoment.isValid();

      // If not valid, try a few other standardized formats
      if (!dateIsValid) {
        _valueAsMoment = (0, _moment.default)(textInputValue, ALLOWED_USER_DATE_FORMATS, true);
        dateIsValid = _valueAsMoment.isValid();
      }
      if (dateIsValid) {
        setTextInputValue(_valueAsMoment.format(dateFormat));
        setValueAsMoment(_valueAsMoment);
        setHasUnparsedText(false);
        setIsTextInvalid(false);
      } else {
        setIsTextInvalid(true);
        setValueAsMoment(null);
      }
      setIsReadyToParse(false);
    }
  }, [isReadyToParse, textInputValue, dateFormat, locale]);
  (0, _services.useUpdateEffect)(function () {
    if (valueAsMoment) {
      onChange(valueAsMoment.toISOString());
    }
  }, [valueAsMoment]);
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_date_picker.EuiDatePicker, {
    inline: true,
    showTimeSelect: true,
    shadow: false,
    selected: valueAsMoment,
    onChange: handleChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    utcOffset: utcOffset,
    minDate: minDate,
    maxDate: maxDate
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    component: "form",
    onSubmit: function onSubmit(e) {
      e.preventDefault(); // Prevents a page refresh/reload
      setIsReadyToParse(true);
    },
    css: styles.euiAbsoluteTabDateForm,
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_form.EuiFormRow, {
    css: styles.euiAbsoluteTabDateForm__row,
    isInvalid: isTextInvalid,
    error: isTextInvalid ? dateFormatError : undefined,
    helpText: hasUnparsedText && !isTextInvalid ? dateFormatError : undefined,
    describedByIds: [timeZomeDescriptionId]
  }, (0, _react2.jsx)(_form.EuiFieldText, {
    "aria-labelledby": textInputLabelId,
    compressed: true,
    isInvalid: isTextInvalid,
    value: textInputValue,
    onChange: handleTextChange,
    onPaste: function onPaste(event) {
      // preventing default here ensures no additional onChange is
      // triggered which otherwise results in input duplication
      event.preventDefault();
      setTextInputValue(event.clipboardData.getData('text'));
      setIsReadyToParse(true);
    },
    "data-test-subj": "superDatePickerAbsoluteDateInput",
    prepend: (0, _react2.jsx)(_form.EuiFormLabel, {
      id: textInputLabelId
    }, labelPrefix)
  })), hasUnparsedText && (0, _react2.jsx)(_button.EuiButtonIcon, {
    type: "submit",
    css: styles.euiAbsoluteTabDateForm__submit,
    size: "s",
    display: "base",
    iconType: "check",
    "aria-label": submitButtonLabel,
    title: submitButtonLabel,
    "data-test-subj": "parseAbsoluteDateFormat"
  })), (0, _react2.jsx)(_timezone_display.EuiTimeZoneDisplay, _extends({
    id: timeZomeDescriptionId
  }, timeZoneDisplayProps)));
};
EuiAbsoluteTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  timeFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool.isRequired,
  labelPrefix: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number,
  minDate: _propTypes.default.any,
  maxDate: _propTypes.default.any,
  timeZoneDisplayProps: _propTypes.default.shape({
    /**
       * A valid time zone name, from the IANA database, e.g. "America/Los_Angeles".
       *
       * @link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
       */
    timeZone: _propTypes.default.string,
    /**
       * Render prop function to add additional content to the time zone display.
       * Useful for e.g. adding links to documentation or setting pages.
       */
    customRender: _propTypes.default.func,
    /**
       * Reference date to be used while resolving the UTC offset.
       * Only useful for edge cases involving daylight saving time.
       */
    date: _propTypes.default.any
  })
};