"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("../../client");
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
class SearchApplication {
    constructor(transport) {
        Object.defineProperty(this, "transport", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, _a, {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.transport = transport;
        this[client_1.kAcceptedParams] = {
            'search_application.delete': {
                path: [
                    'name'
                ],
                body: [],
                query: []
            },
            'search_application.delete_behavioral_analytics': {
                path: [
                    'name'
                ],
                body: [],
                query: []
            },
            'search_application.get': {
                path: [
                    'name'
                ],
                body: [],
                query: []
            },
            'search_application.get_behavioral_analytics': {
                path: [
                    'name'
                ],
                body: [],
                query: []
            },
            'search_application.list': {
                path: [],
                body: [],
                query: [
                    'q',
                    'from',
                    'size'
                ]
            },
            'search_application.post_behavioral_analytics_event': {
                path: [
                    'collection_name',
                    'event_type'
                ],
                body: [
                    'payload'
                ],
                query: [
                    'debug'
                ]
            },
            'search_application.put': {
                path: [
                    'name'
                ],
                body: [
                    'search_application'
                ],
                query: [
                    'create'
                ]
            },
            'search_application.put_behavioral_analytics': {
                path: [
                    'name'
                ],
                body: [],
                query: []
            },
            'search_application.render_query': {
                path: [
                    'name'
                ],
                body: [
                    'params'
                ],
                query: []
            },
            'search_application.search': {
                path: [
                    'name'
                ],
                body: [
                    'params'
                ],
                query: [
                    'typed_keys'
                ]
            }
        };
    }
    async delete(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.delete'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'DELETE';
        const path = `/_application/search_application/${encodeURIComponent(params.name.toString())}`;
        const meta = {
            name: 'search_application.delete',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async deleteBehavioralAnalytics(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.delete_behavioral_analytics'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'DELETE';
        const path = `/_application/analytics/${encodeURIComponent(params.name.toString())}`;
        const meta = {
            name: 'search_application.delete_behavioral_analytics',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async get(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.get'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'GET';
        const path = `/_application/search_application/${encodeURIComponent(params.name.toString())}`;
        const meta = {
            name: 'search_application.get',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async getBehavioralAnalytics(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.get_behavioral_analytics'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        params = params !== null && params !== void 0 ? params : {};
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        let method = '';
        let path = '';
        if (params.name != null) {
            method = 'GET';
            path = `/_application/analytics/${encodeURIComponent(params.name.toString())}`;
        }
        else {
            method = 'GET';
            path = '/_application/analytics';
        }
        const meta = {
            name: 'search_application.get_behavioral_analytics',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async list(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.list'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        params = params !== null && params !== void 0 ? params : {};
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'GET';
        const path = '/_application/search_application';
        const meta = {
            name: 'search_application.list',
            acceptedParams: [
                'q',
                'from',
                'size'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async postBehavioralAnalyticsEvent(params, options) {
        var _b;
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['search_application.post_behavioral_analytics_event'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body = (_b = params.body) !== null && _b !== void 0 ? _b : undefined;
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                // @ts-expect-error
                body = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = 'POST';
        const path = `/_application/analytics/${encodeURIComponent(params.collection_name.toString())}/event/${encodeURIComponent(params.event_type.toString())}`;
        const meta = {
            name: 'search_application.post_behavioral_analytics_event',
            pathParts: {
                collection_name: params.collection_name,
                event_type: params.event_type
            },
            acceptedParams: [
                'collection_name',
                'event_type',
                'payload',
                'debug'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async put(params, options) {
        var _b;
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['search_application.put'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body = (_b = params.body) !== null && _b !== void 0 ? _b : undefined;
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                // @ts-expect-error
                body = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = 'PUT';
        const path = `/_application/search_application/${encodeURIComponent(params.name.toString())}`;
        const meta = {
            name: 'search_application.put',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name',
                'search_application',
                'create'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async putBehavioralAnalytics(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['search_application.put_behavioral_analytics'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'PUT';
        const path = `/_application/analytics/${encodeURIComponent(params.name.toString())}`;
        const meta = {
            name: 'search_application.put_behavioral_analytics',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async renderQuery(params, options) {
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['search_application.render_query'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = 'POST';
        const path = `/_application/search_application/${encodeURIComponent(params.name.toString())}/_render_query`;
        const meta = {
            name: 'search_application.render_query',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name',
                'params'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async search(params, options) {
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['search_application.search'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = body != null ? 'POST' : 'GET';
        const path = `/_application/search_application/${encodeURIComponent(params.name.toString())}/_search`;
        const meta = {
            name: 'search_application.search',
            pathParts: {
                name: params.name
            },
            acceptedParams: [
                'name',
                'params',
                'typed_keys'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
}
_a = client_1.kAcceptedParams;
exports.default = SearchApplication;
//# sourceMappingURL=search_application.js.map