"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = FieldCapsApi;
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
const acceptedParams = {
    field_caps: {
        path: [
            'index'
        ],
        body: [
            'fields',
            'index_filter',
            'runtime_mappings'
        ],
        query: [
            'allow_no_indices',
            'expand_wildcards',
            'fields',
            'ignore_unavailable',
            'include_unmapped',
            'filters',
            'types',
            'include_empty_fields',
            'project_routing'
        ]
    }
};
async function FieldCapsApi(params, options) {
    const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = acceptedParams.field_caps;
    const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
    const querystring = userQuery != null ? { ...userQuery } : {};
    let body;
    const userBody = params === null || params === void 0 ? void 0 : params.body;
    if (userBody != null) {
        if (typeof userBody === 'string') {
            body = userBody;
        }
        else {
            body = { ...userBody };
        }
    }
    params = params !== null && params !== void 0 ? params : {};
    for (const key in params) {
        if (acceptedBody.includes(key)) {
            body = body !== null && body !== void 0 ? body : {};
            // @ts-expect-error
            body[key] = params[key];
        }
        else if (acceptedPath.includes(key)) {
            continue;
        }
        else if (key !== 'body' && key !== 'querystring') {
            if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                // @ts-expect-error
                querystring[key] = params[key];
            }
            else {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
        }
    }
    let method = '';
    let path = '';
    if (params.index != null) {
        method = body != null ? 'POST' : 'GET';
        path = `/${encodeURIComponent(params.index.toString())}/_field_caps`;
    }
    else {
        method = body != null ? 'POST' : 'GET';
        path = '/_field_caps';
    }
    const meta = {
        name: 'field_caps',
        pathParts: {
            index: params.index
        },
        acceptedParams: [
            'index',
            'fields',
            'index_filter',
            'runtime_mappings',
            'allow_no_indices',
            'expand_wildcards',
            'fields',
            'ignore_unavailable',
            'include_unmapped',
            'filters',
            'types',
            'include_empty_fields',
            'project_routing'
        ]
    };
    return await this.transport.request({ path, method, querystring, body, meta }, options);
}
//# sourceMappingURL=field_caps.js.map