"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlignedGrid = AlignedGrid;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
function AlignedGrid({ data, contentComponent: ContentComponent }) {
    const rows = data.length;
    const columns = data.reduce((acc, row) => {
        return Math.max(acc, row.length);
    }, 0);
    const gridStyle = {
        gridTemplateColumns: `repeat(${columns}, 1fr`,
        gridTemplateRows: `repeat(${rows}, max-content 1fr)`,
    };
    return (react_1.default.createElement("div", { className: "echAlignedGrid", style: gridStyle }, data.map((row, rowIndex) => row.map((cell, columnIndex) => {
        const headerStyle = {
            gridRow: rowIndex * 2 + 1,
            gridColumn: columnIndex + 1,
        };
        const contentStyle = {
            gridRow: rowIndex * 2 + 2,
            gridColumn: columnIndex + 1,
        };
        const headerClassName = (0, classnames_1.default)('echAlignedGrid--header', {
            echAlignedGrid__borderRight: columnIndex < columns - 1,
        });
        const contentClassName = (0, classnames_1.default)('echAlignedGrid--content', {
            echAlignedGrid__borderRight: columnIndex < columns - 1,
            echAlignedGrid__borderBottom: rowIndex < rows - 1,
        });
        if (!cell) {
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: headerClassName, style: headerStyle }),
                react_1.default.createElement("div", { className: contentClassName, style: contentStyle })));
        }
        return (react_1.default.createElement("div", { key: `${rowIndex}-${columnIndex}`, className: contentClassName, style: contentStyle },
            react_1.default.createElement(ContentComponent, { datum: cell, stats: { rowIndex, columnIndex, columns, rows } })));
    }))));
}
//# sourceMappingURL=aligned_grid.js.map