"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.countBarsInClusterSelector = void 0;
const compute_series_domains_1 = require("./compute_series_domains");
const specs_1 = require("../../../../specs");
const create_selector_1 = require("../../../../state/create_selector");
const group_data_series_1 = require("../../utils/group_data_series");
const utils_1 = require("../utils/utils");
exports.countBarsInClusterSelector = (0, create_selector_1.createCustomCachedSelector)([compute_series_domains_1.computeSeriesDomainsSelector], function countBarsInCluster({ formattedDataSeries }) {
    const barDataSeries = formattedDataSeries.filter(({ seriesType }) => seriesType === specs_1.SeriesType.Bar);
    const dataSeriesGroupedByPanel = (0, group_data_series_1.groupBy)(barDataSeries, ['smVerticalAccessorValue', 'smHorizontalAccessorValue'], false);
    const barIndexByPanel = Object.keys(dataSeriesGroupedByPanel).reduce((acc, panelKey) => {
        const panelBars = dataSeriesGroupedByPanel[panelKey] ?? [];
        const barDataSeriesByBarIndex = (0, group_data_series_1.groupBy)(panelBars, utils_1.getBarIndexKey, false);
        acc[panelKey] = Object.keys(barDataSeriesByBarIndex);
        return acc;
    }, {});
    return Object.values(barIndexByPanel).reduce((acc, curr) => {
        return Math.max(acc, curr.length);
    }, 0);
});
//# sourceMappingURL=count_bars_in_cluster.js.map