"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkFipsConfig = checkFipsConfig;
exports.isFipsEnabled = isFipsEnabled;
var _crypto = require("crypto");
var _coreBaseServerInternal = require("@kbn/core-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isFipsEnabled(config) {
  var _config$fipsMode$enab, _config$fipsMode;
  return (_config$fipsMode$enab = config === null || config === void 0 ? void 0 : (_config$fipsMode = config.fipsMode) === null || _config$fipsMode === void 0 ? void 0 : _config$fipsMode.enabled) !== null && _config$fipsMode$enab !== void 0 ? _config$fipsMode$enab : false;
}
function checkFipsConfig(config, elasticsearchConfig, serverConfig, logger) {
  const isFipsConfigEnabled = isFipsEnabled(config);
  const isNodeRunningWithFipsEnabled = (0, _crypto.getFips)() === 1;

  // Check if FIPS is enabled in either setting
  if (isFipsConfigEnabled || isNodeRunningWithFipsEnabled) {
    const definedPKCS12ConfigOptions = findDefinedPKCS12ConfigOptions(elasticsearchConfig, serverConfig);
    // FIPS must be enabled on both, or, log/error an exit Kibana
    if (isFipsConfigEnabled !== isNodeRunningWithFipsEnabled) {
      throw new _coreBaseServerInternal.CriticalError(`Configuration mismatch error. xpack.security.fipsMode.enabled is set to ${isFipsConfigEnabled} and the configured Node.js environment has FIPS ${isNodeRunningWithFipsEnabled ? 'enabled' : 'disabled'}`, 'invalidConfig', 78);
    } else if (definedPKCS12ConfigOptions.length > 0) {
      throw new _coreBaseServerInternal.CriticalError(`Configuration mismatch error: ${definedPKCS12ConfigOptions.join(', ')} ${definedPKCS12ConfigOptions.length > 1 ? 'are' : 'is'} set, PKCS12 configurations are not allowed while running in FIPS mode.`, 'invalidConfig', 78);
    } else {
      logger.info('Kibana is running in FIPS mode.');
    }
  }
}
function findDefinedPKCS12ConfigOptions(elasticsearchConfig, serverConfig) {
  var _elasticsearchConfig$, _elasticsearchConfig$2, _elasticsearchConfig$3, _elasticsearchConfig$4, _serverConfig$ssl, _serverConfig$ssl$key, _serverConfig$ssl2, _serverConfig$ssl2$tr;
  const result = [];
  if (elasticsearchConfig !== null && elasticsearchConfig !== void 0 && (_elasticsearchConfig$ = elasticsearchConfig.ssl) !== null && _elasticsearchConfig$ !== void 0 && (_elasticsearchConfig$2 = _elasticsearchConfig$.keystore) !== null && _elasticsearchConfig$2 !== void 0 && _elasticsearchConfig$2.path) {
    result.push('elasticsearch.ssl.keystore.path');
  }
  if (elasticsearchConfig !== null && elasticsearchConfig !== void 0 && (_elasticsearchConfig$3 = elasticsearchConfig.ssl) !== null && _elasticsearchConfig$3 !== void 0 && (_elasticsearchConfig$4 = _elasticsearchConfig$3.truststore) !== null && _elasticsearchConfig$4 !== void 0 && _elasticsearchConfig$4.path) {
    result.push('elasticsearch.ssl.truststore.path');
  }
  if (serverConfig !== null && serverConfig !== void 0 && (_serverConfig$ssl = serverConfig.ssl) !== null && _serverConfig$ssl !== void 0 && (_serverConfig$ssl$key = _serverConfig$ssl.keystore) !== null && _serverConfig$ssl$key !== void 0 && _serverConfig$ssl$key.path) {
    result.push('server.ssl.keystore.path');
  }
  if (serverConfig !== null && serverConfig !== void 0 && (_serverConfig$ssl2 = serverConfig.ssl) !== null && _serverConfig$ssl2 !== void 0 && (_serverConfig$ssl2$tr = _serverConfig$ssl2.truststore) !== null && _serverConfig$ssl2$tr !== void 0 && _serverConfig$ssl2$tr.path) {
    result.push('server.ssl.truststore.path');
  }
  return result;
}