"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ebtSpanFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ignorePaths = ['/kibana-browser'];

// Copied from @elastic/apm-rum/src/common/types.ts

const hasTrackedSpan = spans => {
  // Check if there is any span with a URL other than ignorePaths
  return !spans.every(span => {
    var _span$context, _span$context$http;
    const url = span === null || span === void 0 ? void 0 : (_span$context = span.context) === null || _span$context === void 0 ? void 0 : (_span$context$http = _span$context.http) === null || _span$context$http === void 0 ? void 0 : _span$context$http.url;
    return typeof url === 'string' ? ignorePaths.some(p => url.includes(p)) : false;
  });
};

// Related to https://github.com/elastic/observability-dev/issues/4529
// This filter is only applied to transactions of type 'user-interaction'.
// If a 'user-interaction' transaction contains only EBT spans, it will be filtered out.
const ebtSpanFilter = payload => {
  try {
    if (payload.transactions) {
      payload.transactions = payload.transactions.filter(tr => {
        if (tr.type === 'user-interaction') {
          return hasTrackedSpan(tr.spans);
        }
        // Keep all non-user-interaction transactions
        return true;
      });
    }
  } catch (error) {
    // No need to handle errors here, we will keep the span if there is an error
  }
  return payload;
};
exports.ebtSpanFilter = ebtSpanFilter;