"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cacheMenuItemHeights = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function to cache the heights of the menu items in a ref.
 * It assumes one initial render where all items are in the DOM.
 *
 * @param ref - The ref to the heights cache.
 * @param menu - The menu element.
 * @param items - The menu items.
 */
const cacheMenuItemHeights = (ref, menu, items) => {
  var _ref$current;
  if (((_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.length) !== items.length) {
    const children = Array.from(menu.children);

    // Only cache if the DOM has rendered all the items we expect
    if (children.length === items.length) {
      ref.current = children.map(child => child.clientHeight);
    }
  }
};
exports.cacheMenuItemHeights = cacheMenuItemHeights;