"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _item = require("./item");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/footer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getWrapperStyles = (theme, isCollapsed) => (0, _react2.css)`
  align-items: center;
  border-top: ${theme.border.width.thin} solid ${theme.colors.borderBaseSubdued};
  display: flex;
  flex-direction: column;
  gap: ${theme.size.xs};
  justify-content: center;
  padding-top: ${isCollapsed ? theme.size.s : theme.size.m};
`;
const FooterBase = /*#__PURE__*/(0, _react.forwardRef)(({
  children,
  isCollapsed
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const footerNavigationInstructionsId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'footer-navigation-instructions'
  });
  const handleRef = node => {
    if (typeof ref === 'function') {
      ref(node);
    } else if (ref) {
      ref.current = node;
    }
    if (node) {
      const elements = (0, _get_focusable_elements.getFocusableElements)(node);
      (0, _update_tab_indices.updateTabIndices)(elements);
    }
  };
  const wrapperStyles = (0, _react.useMemo)(() => getWrapperStyles(euiTheme, isCollapsed), [euiTheme, isCollapsed]);
  const renderChildren = () => {
    if (typeof children === 'function') {
      return children({
        footerNavigationInstructionsId
      });
    }
    return children;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: footerNavigationInstructionsId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('core.ui.chrome.sideNavigation.footerInstructions', {
    defaultMessage: 'You are in the main navigation footer menu. Use Up and Down arrow keys to navigate the menu.'
  }))), /*#__PURE__*/_react.default.createElement("footer", {
    "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.footerAriaLabel', {
      defaultMessage: 'Side navigation'
    }),
    css: wrapperStyles,
    onKeyDown: _handle_roving_index.handleRovingIndex,
    ref: handleRef,
    "data-test-subj": `${_constants.NAVIGATION_SELECTOR_PREFIX}-footer`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, renderChildren()));
});
const Footer = exports.Footer = Object.assign(FooterBase, {
  Item: _item.FooterItem
});