"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromeLayoutComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _application = require("./application");
var _banner = require("./banner");
var _navigation = require("./navigation");
var _footer = require("./footer");
var _header = require("./header");
var _sidebar = require("./sidebar");
var _layout = require("./layout.styles");
var _layout_state_context = require("./layout_state_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/layout.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The chrome layout component that composes slots together.
 *
 * @param props - ChromeLayoutComponentProps
 * @returns The rendered ChromeLayoutComponent.
 */
const ChromeLayoutComponent = ({
  children,
  ...props
}) => {
  const layoutState = (0, _layout_state_context.useLayoutState)();
  const styles = (0, _layout.useLayoutStyles)(layoutState);
  const renderSlot = slot => {
    if (typeof slot === 'function') {
      return slot(layoutState);
    }
    return slot;
  };
  const banner = layoutState.hasBanner ? /*#__PURE__*/_react.default.createElement(_banner.LayoutBanner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, renderSlot(props.banner)) : null;
  const footer = layoutState.hasFooter ? /*#__PURE__*/_react.default.createElement(_footer.LayoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, renderSlot(props.footer)) : null;
  const sidebar = layoutState.hasSidebar ? /*#__PURE__*/_react.default.createElement(_sidebar.LayoutSidebar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, renderSlot(props.sidebar)) : null;
  const header = layoutState.hasHeader ? /*#__PURE__*/_react.default.createElement(_header.LayoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, renderSlot(props.header)) : null;
  const navigation = layoutState.hasNavigation ? /*#__PURE__*/_react.default.createElement(_navigation.LayoutNavigation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, renderSlot(props.navigation)) : null;
  const application = /*#__PURE__*/_react.default.createElement(_application.LayoutApplication, {
    topBar: renderSlot(props.applicationTopBar),
    bottomBar: renderSlot(props.applicationBottomBar),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, renderSlot(children));
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.css,
    style: styles.style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, banner, header, navigation, application, footer, sidebar);
};
exports.ChromeLayoutComponent = ChromeLayoutComponent;