"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorConversion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// import { EcsError } from '@elastic/ecs';

function isError(x) {
  return x instanceof Error;
}
const ErrorConversion = exports.ErrorConversion = {
  pattern: /%error/g,
  convert(record) {
    var _record$meta;
    let error;
    if (isError((_record$meta = record.meta) === null || _record$meta === void 0 ? void 0 : _record$meta.error)) {
      var _record$meta2;
      error = (_record$meta2 = record.meta) === null || _record$meta2 === void 0 ? void 0 : _record$meta2.error.stack;
    }
    return error ? `${error}` : '';
  }
};