"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addConnector = exports.AddConnectorApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addConnector = async ({
  deleteExistingConnector,
  indexName,
  name,
  isNative,
  language,
  serviceType,
  uiFlags,
  http
}) => {
  var _result$id, _result$index_name;
  const route = '/internal/content_connectors/connectors';
  const deleteParam = deleteExistingConnector ? {
    delete_existing_connector: deleteExistingConnector
  } : {};
  const params = {
    ...deleteParam,
    index_name: indexName,
    is_native: isNative,
    language,
    name,
    service_type: serviceType
  };
  const result = await (http === null || http === void 0 ? void 0 : http.post(route, {
    body: JSON.stringify(params)
  }));
  return {
    id: (_result$id = result === null || result === void 0 ? void 0 : result.id) !== null && _result$id !== void 0 ? _result$id : '',
    indexName: (_result$index_name = result === null || result === void 0 ? void 0 : result.index_name) !== null && _result$index_name !== void 0 ? _result$index_name : '',
    uiFlags
  };
};
exports.addConnector = addConnector;
const AddConnectorApiLogic = exports.AddConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['add_connector_api_logic'], addConnector);