"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexTabId = exports.PLUGIN_ID = exports.MANAGE_API_KEYS_URL = exports.INPUT_THROTTLE_DELAY_MS = exports.INGESTION_METHOD_IDS = exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = exports.ELASTICSEARCH_PLUGIN = exports.DEFAULT_PIPELINE_VALUES = exports.DEFAULT_PIPELINE_NAME = exports.CREATE_CONNECTOR_PLUGIN = void 0;
var _i18n = require("@kbn/i18n");
var _dedent = _interopRequireDefault(require("dedent"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'content_connectors';
const DEFAULT_PIPELINE_NAME = exports.DEFAULT_PIPELINE_NAME = 'search-default-ingestion';
const DEFAULT_PIPELINE_VALUES = exports.DEFAULT_PIPELINE_VALUES = {
  extract_binary_content: true,
  name: DEFAULT_PIPELINE_NAME,
  reduce_whitespace: true,
  run_ml_inference: true
};
let SearchIndexTabId = exports.SearchIndexTabId = /*#__PURE__*/function (SearchIndexTabId) {
  SearchIndexTabId["OVERVIEW"] = "overview";
  SearchIndexTabId["DOCUMENTS"] = "documents";
  SearchIndexTabId["INDEX_MAPPINGS"] = "index_mappings";
  SearchIndexTabId["PIPELINES"] = "pipelines";
  SearchIndexTabId["CONFIGURATION"] = "configuration";
  SearchIndexTabId["SYNC_RULES"] = "sync_rules";
  SearchIndexTabId["SCHEDULING"] = "scheduling";
  return SearchIndexTabId;
}({});
let INGESTION_METHOD_IDS = exports.INGESTION_METHOD_IDS = /*#__PURE__*/function (INGESTION_METHOD_IDS) {
  INGESTION_METHOD_IDS["API"] = "api";
  INGESTION_METHOD_IDS["CONNECTOR"] = "connector";
  return INGESTION_METHOD_IDS;
}({});
const ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = 'elastic-crawler';
const CREATE_CONNECTOR_PLUGIN = exports.CREATE_CONNECTOR_PLUGIN = {
  CLI_SNIPPET: (0, _dedent.default)`./bin/connectors connector create
  --index-name my-index
  --index-language en
  --from-file config.yml
  `
};
const ELASTICSEARCH_PLUGIN = exports.ELASTICSEARCH_PLUGIN = {
  ID: PLUGIN_ID,
  NAME: _i18n.i18n.translate('xpack.contentConnectors.common.productName', {
    defaultMessage: 'Content connectors'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.contentConnectors.common.productDescription', {
    defaultMessage: 'Low-level tools for creating performant and relevant search experiences.'
  }),
  URL: '/app/management/data/search_connectors/connectors',
  SUPPORT_URL: 'https://discuss.elastic.co/c/elastic-stack/elasticsearch/'
};
const MANAGE_API_KEYS_URL = exports.MANAGE_API_KEYS_URL = '/app/management/security/api_keys';
const INPUT_THROTTLE_DELAY_MS = exports.INPUT_THROTTLE_DELAY_MS = 1000;
const ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = 25;