"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsHostService = exports.EsHostService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Service for managing ES host information.
 *
 * This holds the current ES host (used for copy as cURL functionality)
 * and the list of all available hosts (used for host selection dropdown).
 */
class EsHostService {
  constructor(api) {
    (0, _defineProperty2.default)(this, "host", 'http://localhost:9200');
    (0, _defineProperty2.default)(this, "allHosts", []);
    (0, _defineProperty2.default)(this, "initialized", false);
    (0, _defineProperty2.default)(this, "initPromise", null);
    this.api = api;
  }
  setHost(host) {
    this.host = host;
  }
  setAllHosts(hosts) {
    this.allHosts = hosts;
  }

  /**
   * Initialize the host values based on the values set on the server.
   *
   * This call is necessary because these values can only be retrieved at
   * runtime.
   */
  async init() {
    if (this.initPromise) {
      return this.initPromise;
    }
    this.initPromise = this.doInit();
    return this.initPromise;
  }
  async doInit() {
    try {
      const {
        data
      } = await this.api.getEsConfig();
      if (data) {
        if (data.host) {
          this.setHost(data.host);
        }
        if (data.allHosts) {
          this.setAllHosts(data.allHosts);
        }
      }
      this.initialized = true;
    } catch (error) {
      return Promise.resolve();
    }
  }
  getHost() {
    return this.host;
  }
  getAllHosts() {
    return this.allHosts;
  }
  isInitialized() {
    return this.initialized;
  }

  /**
   * Wait for the service to be initialized before using it
   */
  async waitForInitialization() {
    if (this.initialized) {
      return;
    }
    if (this.initPromise) {
      await this.initPromise;
    }
  }
}
exports.EsHostService = EsHostService;
const createEsHostService = ({
  api
}) => new EsHostService(api);
exports.createEsHostService = createEsHostService;