"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.OpenAiProviderType = exports.OPENAI_LEGACY_COMPLETION_URL = exports.OPENAI_CHAT_URL = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_MODEL = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = exports.AZURE_OPENAI_COMPLETIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = exports.AZURE_OPENAI_CHAT_URL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.gen-ai';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.genAi.title', {
  defaultMessage: 'OpenAI'
});
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["INVOKE_ASYNC_ITERATOR"] = "invokeAsyncIterator";
  SUB_ACTION["STREAM"] = "stream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  return SUB_ACTION;
}({});
let OpenAiProviderType = exports.OpenAiProviderType = /*#__PURE__*/function (OpenAiProviderType) {
  OpenAiProviderType["OpenAi"] = "OpenAI";
  OpenAiProviderType["AzureAi"] = "Azure OpenAI";
  OpenAiProviderType["Other"] = "Other";
  return OpenAiProviderType;
}({});
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 200000;
const DEFAULT_MODEL = exports.DEFAULT_MODEL = 'gpt-4.1';
const OPENAI_CHAT_URL = exports.OPENAI_CHAT_URL = 'https://api.openai.com/v1/chat/completions';
const OPENAI_LEGACY_COMPLETION_URL = exports.OPENAI_LEGACY_COMPLETION_URL = 'https://api.openai.com/v1/completions';
const AZURE_OPENAI_CHAT_URL = exports.AZURE_OPENAI_CHAT_URL = '/openai/deployments/{deployment-id}/chat/completions?api-version={api-version}';
const AZURE_OPENAI_COMPLETIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_URL = '/openai/deployments/{deployment-id}/completions?api-version={api-version}';
const AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = '/openai/deployments/{deployment-id}/extensions/chat/completions?api-version={api-version}';