"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableInferenceCCM = disableInferenceCCM;
exports.enableInferenceCCM = enableInferenceCCM;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function enableInferenceCCM(esClient, apiKey, logger) {
  try {
    await esClient.transport.request({
      method: 'PUT',
      path: '/_inference/_ccm',
      body: {
        api_key: apiKey
      }
    });
    logger.info('Cloud Connect inference enabled successfully');
  } catch (error) {
    logger.error('Failed to enable Cloud Connect inference', {
      error
    });
    throw error;
  }
}
async function disableInferenceCCM(esClient, logger) {
  try {
    await esClient.transport.request({
      method: 'DELETE',
      path: '/_inference/_ccm'
    });
    logger.info('Cloud Connect inference disabled successfully');
  } catch (error) {
    logger.error('Failed to disable Cloud Connect inference', {
      error
    });
    throw error;
  }
}