"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectedAppMain = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("./app_context");
var _use_breadcrumbs = require("./hooks/use_breadcrumbs");
var _onboarding = require("./components/onboarding");
var _connected_services = require("./components/connected_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CloudConnectedAppMain = () => {
  var _appContext$applicati, _appContext$applicati2;
  (0, _use_breadcrumbs.useBreadcrumbs)();
  const appContext = (0, _app_context.useCloudConnectedAppContext)();
  const {
    notifications,
    apiService
  } = appContext;
  const {
    data: config,
    isLoading: isConfigLoading
  } = apiService.useLoadConfig();
  const {
    clusterDetails,
    isLoading: isClusterLoading,
    error: clusterError,
    handleServiceUpdate,
    handleDisconnect,
    handleConnect
  } = (0, _connected_services.useClusterConnection)();

  // Show error toast for cluster loading failures, except for 503.
  // 503 is the expected state when a cluster hasn't been connected to Cloud Connect
  // yet, so we show the onboarding page instead.
  (0, _react.useEffect)(() => {
    if (clusterError && clusterError.statusCode !== 503) {
      notifications.toasts.addError(clusterError, {
        title: 'Failed to load cluster details'
      });
    }
  }, [clusterError, notifications.toasts]);
  const isLoading = isConfigLoading || isClusterLoading && !clusterDetails;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      restrictWidth: 1200,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      style: {
        minHeight: '50vh'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    })))));
  }

  // Extend the context with the fetched config value
  const extendedContext = {
    ...appContext,
    clusterConfig: config,
    hasConfigurePermission: ((_appContext$applicati = appContext.application.capabilities.cloudConnect) === null || _appContext$applicati === void 0 ? void 0 : _appContext$applicati.configure) === true,
    hasActionsSavePrivilege: ((_appContext$applicati2 = appContext.application.capabilities.actions) === null || _appContext$applicati2 === void 0 ? void 0 : _appContext$applicati2.save) === true,
    justConnected: appContext.justConnected,
    setJustConnected: appContext.setJustConnected,
    autoEnablingEis: appContext.autoEnablingEis,
    setAutoEnablingEis: appContext.setAutoEnablingEis
  };
  return /*#__PURE__*/_react.default.createElement(_app_context.CloudConnectedAppContextProvider, {
    value: extendedContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, clusterDetails ? /*#__PURE__*/_react.default.createElement(_connected_services.ConnectedServicesPage, {
    clusterDetails: clusterDetails,
    onServiceUpdate: handleServiceUpdate,
    onDisconnect: handleDisconnect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_onboarding.OnboardingPage, {
    onConnect: handleConnect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))));
};
exports.CloudConnectedAppMain = CloudConnectedAppMain;