"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caseIdIncrementerSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const caseIdIncrementerSavedObjectType = exports.caseIdIncrementerSavedObjectType = {
  name: _constants.CASE_ID_INCREMENTER_SAVED_OBJECT,
  indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
  hidden: true,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      last_id: {
        type: 'keyword'
      },
      '@timestamp': {
        type: 'date'
      },
      updated_at: {
        type: 'date'
      }
    }
  }
};