"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSpacesWithCases = getAllSpacesWithCases;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_BUCKETS_LIMIT = 65535;
async function getAllSpacesWithCases(savedObjectsClient) {
  var _spaces$aggregations$, _spaces$aggregations;
  // This is one way to get all spaces that we want for case analytics purposes.
  // The advantage of this approach is that only spaces that actually contain cases are selected .
  // In turn that means that no unnecessary indices are created.
  // The disadvantage is that the query is an aggregation across the entire cluster and could be
  // slow in case there are many shards and a lot of cases.
  // The alternative is to query the list of all spaces in the cluster and thus creating extra
  // indices that might not be necessary.
  const spaces = await savedObjectsClient.find({
    type: _constants.CASE_SAVED_OBJECT,
    page: 0,
    perPage: 0,
    namespaces: ['*'],
    aggs: {
      spaces: {
        terms: {
          // We want to make sure that we include all spaces, because `terms` aggregations
          // by default only return the top 10 results. `MAX_BUCKETS_LIMIT` is 65k.
          size: MAX_BUCKETS_LIMIT,
          field: `${_constants.CASE_SAVED_OBJECT}.namespaces`
        }
      }
    }
  });
  return (_spaces$aggregations$ = (_spaces$aggregations = spaces.aggregations) === null || _spaces$aggregations === void 0 ? void 0 : _spaces$aggregations.spaces.buckets.map(space => space.key)) !== null && _spaces$aggregations$ !== void 0 ? _spaces$aggregations$ : [];
}