"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAttachmentsAnalyticsIndex = void 0;
var _analytics_index = require("../analytics_index");
var _constants = require("./constants");
var _mappings = require("./mappings");
var _painless_scripts = require("./painless_scripts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAttachmentsAnalyticsIndex = ({
  esClient,
  logger,
  isServerless,
  taskManager,
  spaceId,
  owner
}) => new _analytics_index.AnalyticsIndex({
  logger,
  esClient,
  isServerless,
  taskManager,
  indexName: (0, _constants.getAttachmentsDestinationIndexName)(spaceId, owner),
  indexAlias: (0, _constants.getAttachmentsDestinationIndexAlias)(spaceId, owner),
  indexVersion: _constants.CAI_ATTACHMENTS_INDEX_VERSION,
  mappings: _mappings.CAI_ATTACHMENTS_INDEX_MAPPINGS,
  painlessScriptId: _painless_scripts.CAI_ATTACHMENTS_INDEX_SCRIPT_ID,
  painlessScript: _painless_scripts.CAI_ATTACHMENTS_INDEX_SCRIPT,
  taskId: (0, _constants.getCAIAttachmentsBackfillTaskId)(spaceId, owner),
  sourceIndex: _constants.CAI_ATTACHMENTS_SOURCE_INDEX,
  sourceQuery: (0, _constants.getAttachmentsSourceQuery)(spaceId, owner)
});
exports.createAttachmentsAnalyticsIndex = createAttachmentsAnalyticsIndex;