"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditorField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/json_editor_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useXJsonMode
} = _public.XJson;
const JsonEditorField = ({
  field,
  paramsProperty,
  ariaLabel,
  dataTestSubj,
  euiCodeEditorProps = {}
}) => {
  const {
    label: fieldLabel,
    helpText,
    value: inputTargetValue,
    setValue
  } = field;
  const {
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onDocumentsChange = (0, _react.useCallback)(updatedJson => {
    setValue(updatedJson);
  }, [setValue]);
  const errors = errorMessage ? [errorMessage] : [];
  const label = fieldLabel !== null && fieldLabel !== void 0 ? fieldLabel : _i18n.i18n.translate('xpack.cases.jsonEditorField.defaultLabel', {
    defaultMessage: 'JSON Editor'
  });
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : null);
  (0, _react.useEffect)(() => {
    if (!xJson && inputTargetValue) {
      setXJson(inputTargetValue);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [inputTargetValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    fullWidth: true,
    error: errors,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    helpText: helpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, (0, _extends2.default)({
    languageId: _monaco.XJsonLang.ID,
    options: {
      renderValidationDecorations: xJson ? 'on' : 'off',
      // Disable error underline when empty
      lineNumbers: 'on',
      fontSize: 14,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    },
    value: xJson,
    width: "100%",
    height: "200px",
    "data-test-subj": `${paramsProperty}JsonEditor`,
    "aria-label": ariaLabel
  }, euiCodeEditorProps, {
    onChange: xjson => {
      setXJson(xjson);
      // Keep the documents in sync with the editor content
      onDocumentsChange(convertToJson(xjson));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  })));
};
exports.JsonEditorField = JsonEditorField;
JsonEditorField.displayName = 'JsonEditorField';