"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseAttachmentTabs = exports.SimilarCasesBadge = exports.AttachmentsBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _types = require("../../../common/types");
var _use_cases_context = require("../cases_context/use_cases_context");
var _translations = require("./translations");
var _use_get_case_file_stats = require("../../containers/use_get_case_file_stats");
var _use_case_observables = require("./use_case_observables");
var _experimental_badge = require("../experimental_badge/experimental_badge");
var _use_cases_features = require("../../common/use_cases_features");
var _domain = require("../../../common/types/domain");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/use_case_attachment_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilesBadge = ({
  activeTab,
  fileStatsData,
  isLoading,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLoading && fileStatsData && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-files-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.FILES ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}, fileStatsData.total > 0 ? fileStatsData.total : 0));
FilesBadge.displayName = 'FilesBadge';
const ObservablesBadge = ({
  activeTab,
  isLoading,
  euiTheme,
  count
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-observables-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.OBSERVABLES ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 7
  }
}, count));
ObservablesBadge.displayName = 'ObservablesBadge';
const SimilarCasesBadge = ({
  activeTab,
  count,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-similar-cases-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.SIMILAR_CASES ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 7
  }
}, count !== null && count !== void 0 ? count : 0));
exports.SimilarCasesBadge = SimilarCasesBadge;
SimilarCasesBadge.displayName = 'SimilarCasesBadge';
const AttachmentsBadge = ({
  isActive,
  count,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
  "data-test-subj": "case-view-attachments-badge",
  color: isActive ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 7
  }
}, count !== null && count !== void 0 ? count : 0));
exports.AttachmentsBadge = AttachmentsBadge;
AttachmentsBadge.displayName = 'AttachmentsBadge';
const AlertsBadge = ({
  activeTab,
  totalAlerts,
  isExperimental,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
        margin-left: ${euiTheme.size.xs};
      `,
  "data-test-subj": "case-view-alerts-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.ALERTS ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 143,
    columnNumber: 5
  }
}, totalAlerts || 0), isExperimental && /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, {
  compact: true,
  "data-test-subj": "case-view-alerts-table-experimental-badge",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 7
  }
}));
AlertsBadge.displayName = 'AlertsBadge';
const EventsBadge = ({
  activeTab,
  totalEvents,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  css: (0, _react2.css)`
      margin-left: ${euiTheme.size.xs};
    `,
  "data-test-subj": "case-view-events-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.EVENTS ? 'accent' : 'subdued',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 169,
    columnNumber: 3
  }
}, totalEvents || 0);
EventsBadge.displayName = 'EventsBadge';
const useCaseAttachmentTabs = ({
  caseData,
  activeTab,
  searchTerm
}) => {
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: fileStatsData,
    isLoading: isLoadingFiles
  } = (0, _use_get_case_file_stats.useGetCaseFileStats)({
    caseId: caseData.id,
    searchTerm
  });
  const {
    observables,
    isLoading: isLoadingObservables
  } = (0, _use_case_observables.useCaseObservables)(caseData, searchTerm);
  const {
    observablesAuthorized: canShowObservableTabs,
    isObservablesFeatureEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const stats = (0, _react.useMemo)(() => {
    if (!searchTerm) {
      return {
        totalAlerts: Number(caseData.totalAlerts),
        totalEvents: Number(caseData.totalEvents)
      };
    }
    return caseData.comments.reduce((acc, comment) => {
      if (comment.type === _domain.AttachmentType.alert && features.alerts.enabled) {
        acc.totalAlerts = Array.isArray(comment.alertId) ? acc.totalAlerts + comment.alertId.length : acc.totalAlerts + 1;
      } else if (comment.type === _domain.AttachmentType.event && features.events.enabled) {
        acc.totalEvents = Array.isArray(comment.eventId) ? acc.totalEvents + comment.eventId.length : acc.totalEvents + 1;
      }
      return acc;
    }, {
      totalEvents: 0,
      totalAlerts: 0
    });
  }, [searchTerm, features, caseData]);
  const totalAttachments = stats.totalAlerts + stats.totalEvents + Number(fileStatsData === null || fileStatsData === void 0 ? void 0 : fileStatsData.total) + (canShowObservableTabs && isObservablesFeatureEnabled ? observables.length : 0);
  const tabsConfig = (0, _react.useMemo)(() => [...(features.alerts.enabled ? [{
    id: _types.CASE_VIEW_PAGE_TABS.ALERTS,
    name: _translations.ALERTS_TAB,
    badge: /*#__PURE__*/_react.default.createElement(AlertsBadge, {
      isExperimental: features.alerts.isExperimental,
      totalAlerts: stats.totalAlerts,
      activeTab: activeTab,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 17
      }
    })
  }] : []), ...(features.events.enabled ? [{
    id: _types.CASE_VIEW_PAGE_TABS.EVENTS,
    name: _translations.EVENTS_TAB,
    badge: /*#__PURE__*/_react.default.createElement(EventsBadge, {
      totalEvents: stats.totalEvents,
      activeTab: activeTab,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 17
      }
    })
  }] : []), {
    id: _types.CASE_VIEW_PAGE_TABS.FILES,
    name: _translations.FILES_TAB,
    badge: /*#__PURE__*/_react.default.createElement(FilesBadge, {
      isLoading: isLoadingFiles,
      fileStatsData: fileStatsData,
      activeTab: activeTab,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 11
      }
    })
  }, ...(canShowObservableTabs && isObservablesFeatureEnabled ? [{
    id: _types.CASE_VIEW_PAGE_TABS.OBSERVABLES,
    name: _translations.OBSERVABLES_TAB,
    badge: /*#__PURE__*/_react.default.createElement(ObservablesBadge, {
      isLoading: isLoadingObservables,
      count: observables.length,
      activeTab: activeTab,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 17
      }
    })
  }] : [])], [activeTab, canShowObservableTabs, stats.totalAlerts, stats.totalEvents, euiTheme, features.alerts.enabled, features.alerts.isExperimental, features.events.enabled, fileStatsData, isLoadingFiles, isLoadingObservables, isObservablesFeatureEnabled, observables.length]);
  return {
    tabs: tabsConfig,
    totalAttachments
  };
};
exports.useCaseAttachmentTabs = useCaseAttachmentTabs;