"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _translations = require("./translations");
var _use_case_attachment_tabs = require("./use_case_attachment_tabs");
var _use_get_similar_cases = require("../../containers/use_get_similar_cases");
var _use_cases_features = require("../../common/use_cases_features");
var _use_attachments_tab_ebt = require("../../analytics/use_attachments_tab_ebt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/case_view_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseViewTabs = exports.CaseViewTabs = /*#__PURE__*/_react.default.memo(({
  caseData,
  activeTab,
  searchTerm
}) => {
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const {
    tabs: attachmentTabs,
    totalAttachments
  } = (0, _use_case_attachment_tabs.useCaseAttachmentTabs)({
    caseData,
    activeTab,
    searchTerm
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    observablesAuthorized: canShowObservableTabs,
    isObservablesFeatureEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: similarCasesData
  } = (0, _use_get_similar_cases.useGetSimilarCases)({
    caseId: caseData.id,
    perPage: 0,
    page: 0,
    enabled: canShowObservableTabs && isObservablesFeatureEnabled
  });
  const isAttachmentsTabActive = (0, _react.useMemo)(() => !!attachmentTabs.find(attachmentTab => attachmentTab.id === activeTab), [activeTab, attachmentTabs]);
  const defaultAttachmentsTabId = attachmentTabs[0].id;
  const tabs = (0, _react.useMemo)(() => [{
    id: _types.CASE_VIEW_PAGE_TABS.ACTIVITY,
    name: _translations.ACTIVITY_TAB
  }, {
    id: _types.CASE_VIEW_PAGE_TABS.ATTACHMENTS,
    name: _translations.ATTACHMENTS_TAB,
    badge: /*#__PURE__*/_react.default.createElement(_use_case_attachment_tabs.AttachmentsBadge, {
      isActive: isAttachmentsTabActive,
      euiTheme: euiTheme,
      count: totalAttachments,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })
  }, {
    id: _types.CASE_VIEW_PAGE_TABS.SIMILAR_CASES,
    name: _translations.SIMILAR_CASES_TAB,
    badge: /*#__PURE__*/_react.default.createElement(_use_case_attachment_tabs.SimilarCasesBadge, {
      activeTab: activeTab,
      euiTheme: euiTheme,
      count: similarCasesData === null || similarCasesData === void 0 ? void 0 : similarCasesData.total,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    })
  }], [activeTab, euiTheme, isAttachmentsTabActive, similarCasesData === null || similarCasesData === void 0 ? void 0 : similarCasesData.total, totalAttachments]);
  const trackAttachmentsTabClick = (0, _use_attachments_tab_ebt.useAttachmentsTabClickedEBT)();
  const trackAttachmentsSubTabClick = (0, _use_attachments_tab_ebt.useAttachmentsSubTabClickedEBT)();
  const renderTabs = (0, _react.useCallback)(() => {
    return tabs.map((tab, index) => {
      var _tab$badge;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        "data-test-subj": `case-view-tab-title-${tab.id}`,
        key: index,
        onClick: () => {
          if (tab.id === _types.CASE_VIEW_PAGE_TABS.ATTACHMENTS) {
            trackAttachmentsTabClick();
            // NOTE: counting default sub-tab click here as it is already picked when navigating to attachments tab
            trackAttachmentsSubTabClick(defaultAttachmentsTabId);
          }
          navigateToCaseView({
            detailName: caseData.id,
            tabId: tab.id === _types.CASE_VIEW_PAGE_TABS.ATTACHMENTS ? _types.CASE_VIEW_PAGE_TABS.ALERTS : tab.id
          });
        },
        isSelected: tab.id === activeTab || tab.id === _types.CASE_VIEW_PAGE_TABS.ATTACHMENTS && isAttachmentsTabActive,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 7
        }
      }, tab.name, (_tab$badge = tab.badge) !== null && _tab$badge !== void 0 ? _tab$badge : null);
    });
  }, [tabs, activeTab, isAttachmentsTabActive, navigateToCaseView, caseData.id, trackAttachmentsTabClick, trackAttachmentsSubTabClick, defaultAttachmentsTabId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "case-view-tabs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 10
    }
  }, renderTabs());
});
CaseViewTabs.displayName = 'CaseViewTabs';