"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetsReducer = void 0;
var _reduxActions = require("redux-actions");
var _objectPathImmutable = require("object-path-immutable");
var _lodash = require("lodash");
var _assets = require("../actions/assets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetsReducer = exports.assetsReducer = (0, _reduxActions.handleActions)({
  [_assets.setAssetValue]: (assetState, {
    payload
  }) => {
    const {
      id,
      value
    } = payload;
    const asset = (0, _lodash.get)(assetState, [id]);
    if (!asset) {
      throw new Error(`Can not set asset data, id not found: ${id}`);
    }
    return (0, _objectPathImmutable.assign)(assetState, id, {
      value
    });
  },
  [_assets.setAsset]: (assetState, {
    payload
  }) => {
    const {
      asset
    } = payload;
    return (0, _objectPathImmutable.set)(assetState, asset.id, asset);
  },
  [_assets.removeAsset]: (assetState, {
    payload: assetId
  }) => {
    return (0, _objectPathImmutable.del)(assetState, assetId);
  },
  [(0, _reduxActions.combineActions)(_assets.setAssets, _assets.resetAssets)]: (_assetState, {
    payload
  }) => payload || {}
}, {});