"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VarConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _i18n = require("@kbn/i18n");
var _var_config = require("./var_config");
var _services = require("../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/var_config/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getCopyNotificationDescription: () => _i18n.i18n.translate('xpack.canvas.varConfig.copyNotificationDescription', {
    defaultMessage: 'Variable syntax copied to clipboard'
  }),
  getDeleteNotificationDescription: () => _i18n.i18n.translate('xpack.canvas.varConfig.deleteNotificationDescription', {
    defaultMessage: 'Variable successfully deleted'
  })
};
const VarConfig = ({
  variables,
  setVariables
}) => {
  const {
    success
  } = (0, _services.useNotifyService)();
  const onDeleteVar = v => {
    const index = variables.findIndex(targetVar => {
      return targetVar.name === v.name;
    });
    if (index !== -1) {
      const newVars = [...variables];
      newVars.splice(index, 1);
      setVariables(newVars);
      success(strings.getDeleteNotificationDescription());
    }
  };
  const onCopyVar = v => {
    const snippetStr = `{var "${v.name}"}`;
    (0, _copyToClipboard.default)(snippetStr, {
      debug: true
    });
    success(strings.getCopyNotificationDescription());
  };
  const onAddVar = v => {
    setVariables([...variables, v]);
  };
  const onEditVar = (oldVar, newVar) => {
    const existingVarIndex = variables.findIndex(v => oldVar.name === v.name);
    const newVars = [...variables];
    newVars[existingVarIndex] = newVar;
    setVariables(newVars);
  };
  return /*#__PURE__*/_react.default.createElement(_var_config.VarConfig, {
    variables,
    onCopyVar,
    onDeleteVar,
    onAddVar,
    onEditVar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 10
    }
  });
};
exports.VarConfig = VarConfig;