"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TASK_STATUSES = exports.INTEGRATION_SAVED_OBJECT_TYPE = exports.INPUT_TYPES = exports.DATA_STREAM_SAVED_OBJECT_TYPE = exports.BULK_DELETE_CHUNK_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_SAVED_OBJECT_TYPE = exports.INTEGRATION_SAVED_OBJECT_TYPE = 'integration-config';
const DATA_STREAM_SAVED_OBJECT_TYPE = exports.DATA_STREAM_SAVED_OBJECT_TYPE = 'data_stream-config';
const TASK_STATUSES = exports.TASK_STATUSES = {
  pending: 'pending',
  processing: 'processing',
  completed: 'completed',
  failed: 'failed',
  cancelled: 'cancelled'
};
const INPUT_TYPES = exports.INPUT_TYPES = {
  awsCloudwatch: 'aws-cloudwatch',
  awsS3: 'aws-s3',
  azureBlobStorage: 'azure-blob-storage',
  azureEventhub: 'azure-eventhub',
  cel: 'cel',
  cloudfoundry: 'cloudfoundry',
  filestream: 'filestream',
  gcpPubsub: 'gcp-pubsub',
  gcs: 'gcs',
  httpEndpoint: 'http_endpoint',
  journald: 'journald',
  kafka: 'kafka',
  tcp: 'tcp',
  udp: 'udp'
};

// Saved Objects Operations
const BULK_DELETE_CHUNK_SIZE = exports.BULK_DELETE_CHUNK_SIZE = 50;