"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Event type definitions
let TelemetryEventType = exports.TelemetryEventType = /*#__PURE__*/function (TelemetryEventType) {
  TelemetryEventType["UploadIntegrationZipComplete"] = "upload_integration_zip_complete";
  TelemetryEventType["AutomaticImportOpen"] = "automatic_import_open";
  TelemetryEventType["AutomaticImportStepComplete"] = "automatic_import_step_complete";
  TelemetryEventType["AutomaticImportGenerationComplete"] = "automatic_import_generation_complete";
  TelemetryEventType["AutomaticImportCelGenerationComplete"] = "automatic_import_cel_generation_complete";
  TelemetryEventType["AutomaticImportComplete"] = "automatic_import_complete";
  return TelemetryEventType;
}({}); // Event data definitions
/**
 * TelemetryEventTypeData
 * Defines the relation between event types and their corresponding event data
 * */