/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[5926],{25926:e=>{e.exports=JSON.parse('{"attributes":{"controlGroupInput":{"chainingSystem":"HIERARCHICAL","controlStyle":"oneLine","ignoreParentSettingsJSON":"{\\"ignoreFilters\\":false,\\"ignoreQuery\\":false,\\"ignoreTimerange\\":false,\\"ignoreValidations\\":false}","panelsJSON":"{\\"46ebbfe2-a47c-420c-8e27-c0d3cfb89446\\":{\\"grow\\":true,\\"order\\":0,\\"type\\":\\"optionsListControl\\",\\"width\\":\\"large\\",\\"explicitInput\\":{\\"dataViewId\\":\\"apm_static_data_view_id_default\\",\\"fieldName\\":\\"service.instance.id\\",\\"title\\":\\"JVM instance\\",\\"exclude\\":false,\\"existsSelected\\":false,\\"selectedOptions\\":[],\\"searchTechnique\\":\\"wildcard\\",\\"sort\\":{\\"by\\":\\"_count\\",\\"direction\\":\\"desc\\"}}}}","showApplySelections":false},"description":"","kibanaSavedObjectMeta":{"searchSourceJSON":"{\\"filter\\":[],\\"query\\":{\\"query\\":\\"\\",\\"language\\":\\"kuery\\"}}"},"optionsJSON":"{\\"useMargins\\":true,\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"hidePanelTitles\\":false}","panelsJSON":"[{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"hidePanelTitles\\":true,\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.cpu.recent_utilization IS NOT NULL OR jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL OR jvm.thread.count IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = MAX(jvm.thread.count)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, jvm.thread.daemon, jvm.thread.state, time_bucket = BUCKET(@timestamp, 1 minute)\\\\n  | STATS cpu = AVG(cpu),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = SUM(max_threads)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, time_bucket\\\\n  | STATS cpu = AVG(cpu), heap_used = SUM(heap_used), off_heap_used = SUM(off_heap_used), heap_limit = SUM(heap_limit), max_threads = MAX(max_threads) by service.instance.id, host.name, time_bucket\\\\n  | EVAL heap_usage_perc = heap_used/heap_limit\\\\n  | STATS cpu = AVG(cpu), heap_usage_perc = AVG(heap_usage_perc), heap_used = AVG(heap_used), off_heap_used = AVG(off_heap_used), max_threads = MAX(max_threads), last_seen = MAX(time_bucket) by service.instance.id, host.name\\\\n  | SORT last_seen DESC\\\\n  | LIMIT 100 \\"},\\"attributes\\":{\\"title\\":\\"cpu & heap_usage_perc & heap_used & off_heap_used & max_threads of (empty)\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"374a6a20-5252-4dea-94cb-13c9964da141\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.cpu.recent_utilization IS NOT NULL OR jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL OR jvm.thread.count IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = MAX(jvm.thread.count)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, jvm.thread.daemon, jvm.thread.state, time_bucket = BUCKET(@timestamp, 1 minute)\\\\n  | STATS cpu = AVG(cpu),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = SUM(max_threads)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, time_bucket\\\\n  | STATS cpu = AVG(cpu), heap_used = SUM(heap_used), off_heap_used = SUM(off_heap_used), heap_limit = SUM(heap_limit), max_threads = MAX(max_threads) by service.instance.id, host.name, time_bucket\\\\n  | EVAL heap_usage_perc = heap_used/heap_limit\\\\n  | STATS cpu = AVG(cpu), heap_usage_perc = AVG(heap_usage_perc), heap_used = AVG(heap_used), off_heap_used = AVG(off_heap_used), max_threads = MAX(max_threads), last_seen = MAX(time_bucket) by service.instance.id, host.name\\\\n  | SORT last_seen DESC\\\\n  | LIMIT 100 \\"},\\"columns\\":[{\\"columnId\\":\\"353b1042-60e5-48ce-9418-28b613ec5da7\\",\\"fieldName\\":\\"service.instance.id\\",\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\",\\"sourceParams\\":{}},\\"label\\":\\"JVM instance\\",\\"customLabel\\":true},{\\"columnId\\":\\"0cf3124a-1ea3-48e8-af26-e76be32a924c\\",\\"fieldName\\":\\"host.name\\",\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\",\\"sourceParams\\":{}},\\"label\\":\\"Host name\\",\\"customLabel\\":true},{\\"columnId\\":\\"cpu\\",\\"fieldName\\":\\"cpu\\",\\"label\\":\\"CPU avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"heap_usage_perc\\",\\"fieldName\\":\\"heap_usage_perc\\",\\"label\\":\\"Heap Usage Avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"heap_used\\",\\"fieldName\\":\\"heap_used\\",\\"label\\":\\"Heap avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"off_heap_used\\",\\"fieldName\\":\\"off_heap_used\\",\\"label\\":\\"Non-heap avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"max_threads\\",\\"fieldName\\":\\"max_threads\\",\\"label\\":\\"Thread count max\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"6786f893-0b65-4994-ab6d-ee0d059a2880\\",\\"fieldName\\":\\"last_seen\\",\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\",\\"sourceParams\\":{\\"appliedTimeRange\\":{\\"type\\":\\"timerange\\",\\"from\\":\\"2025-03-12T12:38:04.540Z\\",\\"to\\":\\"2025-03-12T17:08:44.146Z\\"},\\"params\\":{}}},\\"label\\":\\"Last Seen\\",\\"customLabel\\":true}],\\"timeField\\":\\"@timestamp\\",\\"allColumns\\":[{\\"columnId\\":\\"cpu\\",\\"fieldName\\":\\"cpu\\",\\"label\\":\\"cpu\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"heap_usage_perc\\",\\"fieldName\\":\\"heap_usage_perc\\",\\"label\\":\\"heap_usage_perc\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"heap_used\\",\\"fieldName\\":\\"heap_used\\",\\"label\\":\\"heap_used\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"off_heap_used\\",\\"fieldName\\":\\"off_heap_used\\",\\"label\\":\\"off_heap_used\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"max_threads\\",\\"fieldName\\":\\"max_threads\\",\\"label\\":\\"max_threads\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true}]}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.cpu.recent_utilization IS NOT NULL OR jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL OR jvm.thread.count IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = MAX(jvm.thread.count)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, jvm.thread.daemon, jvm.thread.state, time_bucket = BUCKET(@timestamp, 1 minute)\\\\n  | STATS cpu = AVG(cpu),\\\\n          heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          max_threads = SUM(max_threads)\\\\n          BY service.instance.id, host.name, jvm.memory.pool.name, time_bucket\\\\n  | STATS cpu = AVG(cpu), heap_used = SUM(heap_used), off_heap_used = SUM(off_heap_used), heap_limit = SUM(heap_limit), max_threads = MAX(max_threads) by service.instance.id, host.name, time_bucket\\\\n  | EVAL heap_usage_perc = heap_used/heap_limit\\\\n  | STATS cpu = AVG(cpu), heap_usage_perc = AVG(heap_usage_perc), heap_used = AVG(heap_used), off_heap_used = AVG(off_heap_used), max_threads = MAX(max_threads), last_seen = MAX(time_bucket) by service.instance.id, host.name\\\\n  | SORT last_seen DESC\\\\n  | LIMIT 100 \\"},\\"visualization\\":{\\"layerId\\":\\"374a6a20-5252-4dea-94cb-13c9964da141\\",\\"layerType\\":\\"data\\",\\"columns\\":[{\\"isTransposed\\":false,\\"columnId\\":\\"cpu\\",\\"isMetric\\":true,\\"colorMode\\":\\"text\\",\\"palette\\":{\\"name\\":\\"custom\\",\\"type\\":\\"palette\\",\\"params\\":{\\"steps\\":5,\\"stops\\":[{\\"color\\":\\"#209280\\",\\"stop\\":0.5},{\\"color\\":\\"#54b399\\",\\"stop\\":0.7},{\\"color\\":\\"#d6bf57\\",\\"stop\\":0.8},{\\"color\\":\\"#e7664c\\",\\"stop\\":0.9},{\\"color\\":\\"#cc5642\\",\\"stop\\":1.9}],\\"name\\":\\"custom\\",\\"colorStops\\":[{\\"color\\":\\"#209280\\",\\"stop\\":0},{\\"color\\":\\"#54b399\\",\\"stop\\":0.5},{\\"color\\":\\"#d6bf57\\",\\"stop\\":0.7},{\\"color\\":\\"#e7664c\\",\\"stop\\":0.8},{\\"color\\":\\"#cc5642\\",\\"stop\\":0.9}],\\"continuity\\":\\"above\\",\\"reverse\\":false,\\"rangeMin\\":0,\\"rangeMax\\":null,\\"rangeType\\":\\"number\\"}},\\"width\\":53.73214285714286},{\\"columnId\\":\\"heap_usage_perc\\",\\"colorMode\\":\\"text\\",\\"palette\\":{\\"name\\":\\"custom\\",\\"type\\":\\"palette\\",\\"params\\":{\\"steps\\":5,\\"stops\\":[{\\"color\\":\\"#209280\\",\\"stop\\":0.5},{\\"color\\":\\"#54b399\\",\\"stop\\":0.7},{\\"color\\":\\"#d6bf57\\",\\"stop\\":0.8},{\\"color\\":\\"#e7664c\\",\\"stop\\":0.9},{\\"color\\":\\"#cc5642\\",\\"stop\\":1.9}],\\"rangeType\\":\\"number\\",\\"rangeMin\\":0,\\"rangeMax\\":null,\\"name\\":\\"custom\\",\\"colorStops\\":[{\\"color\\":\\"#209280\\",\\"stop\\":0},{\\"color\\":\\"#54b399\\",\\"stop\\":0.5},{\\"color\\":\\"#d6bf57\\",\\"stop\\":0.7},{\\"color\\":\\"#e7664c\\",\\"stop\\":0.8},{\\"color\\":\\"#cc5642\\",\\"stop\\":0.9}],\\"continuity\\":\\"above\\",\\"reverse\\":false}}},{\\"columnId\\":\\"heap_used\\"},{\\"columnId\\":\\"off_heap_used\\"},{\\"columnId\\":\\"max_threads\\"},{\\"columnId\\":\\"353b1042-60e5-48ce-9418-28b613ec5da7\\",\\"isTransposed\\":false,\\"isMetric\\":true,\\"width\\":336.875},{\\"columnId\\":\\"0cf3124a-1ea3-48e8-af26-e76be32a924c\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"6786f893-0b65-4994-ab6d-ee0d059a2880\\",\\"isTransposed\\":false,\\"isMetric\\":true}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsDatatable\\"},\\"title\\":\\"JVM overview\\"},\\"panelIndex\\":\\"3f7c1054-b905-4a1a-9394-91744b55429f\\",\\"gridData\\":{\\"i\\":\\"3f7c1054-b905-4a1a-9394-91744b55429f\\",\\"y\\":0,\\"x\\":0,\\"w\\":48,\\"h\\":13}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"title\\":\\"CPU Usage\\",\\"hidePanelTitles\\":false,\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS process_cpu_avg = AVG(jvm.cpu.recent_utilization),\\\\n          process_cpu_max = MAX(jvm.cpu.recent_utilization)\\\\n          BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS process_cpu_avg = AVG(process_cpu_avg),\\\\n          process_cpu_max = AVG(process_cpu_max)\\\\n          BY @timestamp\\\\n  | RENAME process_cpu_avg AS `Process avg`,\\\\n           process_cpu_max AS `Process max`\\"},\\"attributes\\":{\\"title\\":\\"Process avg & Process max over @timestamp\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"ab435c5d-7dde-49ea-ab1b-f26ccb36f8d8\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS process_cpu_avg = AVG(jvm.cpu.recent_utilization),\\\\n          process_cpu_max = MAX(jvm.cpu.recent_utilization)\\\\n          BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS process_cpu_avg = AVG(process_cpu_avg),\\\\n          process_cpu_max = AVG(process_cpu_max)\\\\n          BY @timestamp\\\\n  | RENAME process_cpu_avg AS `Process avg`,\\\\n           process_cpu_max AS `Process max`\\"},\\"columns\\":[{\\"columnId\\":\\"Process avg\\",\\"fieldName\\":\\"Process avg\\",\\"label\\":\\"Process avg\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":1}}}},{\\"columnId\\":\\"Process max\\",\\"fieldName\\":\\"Process max\\",\\"label\\":\\"Process max\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":1}}}},{\\"columnId\\":\\"@timestamp\\",\\"fieldName\\":\\"@timestamp\\",\\"label\\":\\"@timestamp\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\"}}],\\"timeField\\":\\"@timestamp\\"}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS process_cpu_avg = AVG(jvm.cpu.recent_utilization),\\\\n          process_cpu_max = MAX(jvm.cpu.recent_utilization)\\\\n          BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS process_cpu_avg = AVG(process_cpu_avg),\\\\n          process_cpu_max = AVG(process_cpu_max)\\\\n          BY @timestamp\\\\n  | RENAME process_cpu_avg AS `Process avg`,\\\\n           process_cpu_max AS `Process max`\\"},\\"visualization\\":{\\"legend\\":{\\"isVisible\\":true,\\"position\\":\\"bottom\\"},\\"valueLabels\\":\\"hide\\",\\"fittingFunction\\":\\"Linear\\",\\"yLeftExtent\\":{\\"mode\\":\\"custom\\",\\"upperBound\\":1,\\"lowerBound\\":0},\\"axisTitlesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":false,\\"yRight\\":true},\\"tickLabelsVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"labelsOrientation\\":{\\"x\\":0,\\"yLeft\\":0,\\"yRight\\":0},\\"gridlinesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"preferredSeriesType\\":\\"line\\",\\"layers\\":[{\\"layerId\\":\\"ab435c5d-7dde-49ea-ab1b-f26ccb36f8d8\\",\\"seriesType\\":\\"line\\",\\"xAccessor\\":\\"@timestamp\\",\\"accessors\\":[\\"Process avg\\",\\"Process max\\"],\\"layerType\\":\\"data\\",\\"colorMapping\\":{\\"assignments\\":[],\\"specialAssignments\\":[{\\"rules\\":[{\\"type\\":\\"other\\"}],\\"color\\":{\\"type\\":\\"loop\\"},\\"touched\\":false}],\\"paletteId\\":\\"default\\",\\"colorMode\\":{\\"type\\":\\"categorical\\"}}}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsXY\\"}},\\"panelIndex\\":\\"84a4452e-bb8b-4b0a-8fde-b109ad0aa9b3\\",\\"gridData\\":{\\"i\\":\\"84a4452e-bb8b-4b0a-8fde-b109ad0aa9b3\\",\\"y\\":13,\\"x\\":0,\\"w\\":24,\\"h\\":15}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"description\\":\\"Shows the absolute memory usage of the JVM per memory region.\\",\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used = AVG(off_heap_used),\\\\n          heap_used = AVG(heap_used)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used AS `Non Heap`, heap_used AS `Heap`\\"},\\"attributes\\":{\\"title\\":\\"Non Heap & Heap over @timestamp\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"ddf9e3df-039c-4bc0-83ef-fb92fb0e875d\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used = AVG(off_heap_used),\\\\n          heap_used = AVG(heap_used)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used AS `Non Heap`, heap_used AS `Heap`\\"},\\"columns\\":[{\\"columnId\\":\\"Non Heap\\",\\"fieldName\\":\\"Non Heap\\",\\"label\\":\\"Non Heap\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"Heap\\",\\"fieldName\\":\\"Heap\\",\\"label\\":\\"Heap\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"jvm.memory.pool.name\\",\\"fieldName\\":\\"jvm.memory.pool.name\\",\\"label\\":\\"jvm.memory.pool.name\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\"}},{\\"columnId\\":\\"@timestamp\\",\\"fieldName\\":\\"@timestamp\\",\\"label\\":\\"@timestamp\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\"}}],\\"timeField\\":\\"@timestamp\\"}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used = AVG(off_heap_used),\\\\n          heap_used = AVG(heap_used)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used AS `Non Heap`, heap_used AS `Heap`\\"},\\"visualization\\":{\\"legend\\":{\\"isVisible\\":false,\\"position\\":\\"right\\",\\"showSingleSeries\\":false},\\"valueLabels\\":\\"hide\\",\\"fittingFunction\\":\\"None\\",\\"axisTitlesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":false,\\"yRight\\":true},\\"tickLabelsVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"labelsOrientation\\":{\\"x\\":0,\\"yLeft\\":0,\\"yRight\\":0},\\"gridlinesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"preferredSeriesType\\":\\"area_stacked\\",\\"layers\\":[{\\"layerId\\":\\"ddf9e3df-039c-4bc0-83ef-fb92fb0e875d\\",\\"seriesType\\":\\"area_stacked\\",\\"xAccessor\\":\\"@timestamp\\",\\"splitAccessor\\":\\"jvm.memory.pool.name\\",\\"accessors\\":[\\"Non Heap\\",\\"Heap\\"],\\"layerType\\":\\"data\\",\\"colorMapping\\":{\\"assignments\\":[],\\"specialAssignments\\":[{\\"rule\\":{\\"type\\":\\"other\\"},\\"color\\":{\\"type\\":\\"loop\\"},\\"touched\\":false}],\\"paletteId\\":\\"eui_amsterdam_color_blind\\",\\"colorMode\\":{\\"type\\":\\"categorical\\"}},\\"collapseFn\\":\\"\\"}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsXY\\"},\\"title\\":\\"Absolute Memory Usage\\"},\\"panelIndex\\":\\"3b58b2a1-20c6-4fdb-994e-d4e3dde571ea\\",\\"gridData\\":{\\"i\\":\\"3b58b2a1-20c6-4fdb-994e-d4e3dde571ea\\",\\"y\\":13,\\"x\\":24,\\"w\\":24,\\"h\\":15}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.thread.count IS NOT NULL\\\\n  | STATS thread_count = AVG(jvm.thread.count)\\\\n          BY service.instance.id, jvm.thread.state, jvm.thread.daemon, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS thread_count = SUM(thread_count) BY service.instance.id, jvm.thread.state, @timestamp\\\\n  | STATS thread_count = AVG(thread_count) BY  jvm.thread.state, @timestamp\\\\n  | RENAME thread_count AS `Thread Count`\\"},\\"attributes\\":{\\"title\\":\\"Thread Count over @timestamp\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"d5811038-a7dc-4e74-9cdf-7487289a646d\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.thread.count IS NOT NULL\\\\n  | STATS thread_count = AVG(jvm.thread.count)\\\\n          BY service.instance.id, jvm.thread.state, jvm.thread.daemon, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS thread_count = SUM(thread_count) BY service.instance.id, jvm.thread.state, @timestamp\\\\n  | STATS thread_count = AVG(thread_count) BY  jvm.thread.state, @timestamp\\\\n  | RENAME thread_count AS `Thread Count`\\"},\\"columns\\":[{\\"columnId\\":\\"Thread Count\\",\\"fieldName\\":\\"Thread Count\\",\\"label\\":\\"Thread Count\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"number\\",\\"params\\":{\\"decimals\\":0}}}},{\\"columnId\\":\\"jvm.thread.state\\",\\"fieldName\\":\\"jvm.thread.state\\",\\"label\\":\\"jvm.thread.state\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\"}},{\\"columnId\\":\\"@timestamp\\",\\"fieldName\\":\\"@timestamp\\",\\"label\\":\\"@timestamp\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\"}}],\\"timeField\\":\\"@timestamp\\"}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.thread.count IS NOT NULL\\\\n  | STATS thread_count = AVG(jvm.thread.count)\\\\n          BY service.instance.id, jvm.thread.state, jvm.thread.daemon, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS thread_count = SUM(thread_count) BY service.instance.id, jvm.thread.state, @timestamp\\\\n  | STATS thread_count = AVG(thread_count) BY  jvm.thread.state, @timestamp\\\\n  | RENAME thread_count AS `Thread Count`\\"},\\"visualization\\":{\\"legend\\":{\\"isVisible\\":false,\\"position\\":\\"bottom\\",\\"showSingleSeries\\":false},\\"valueLabels\\":\\"hide\\",\\"fittingFunction\\":\\"None\\",\\"yTitle\\":\\"Number of Threads\\",\\"axisTitlesVisibilitySettings\\":{\\"x\\":false,\\"yLeft\\":true,\\"yRight\\":true},\\"tickLabelsVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"labelsOrientation\\":{\\"x\\":0,\\"yLeft\\":0,\\"yRight\\":0},\\"gridlinesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"preferredSeriesType\\":\\"area_stacked\\",\\"layers\\":[{\\"layerId\\":\\"d5811038-a7dc-4e74-9cdf-7487289a646d\\",\\"seriesType\\":\\"area_stacked\\",\\"xAccessor\\":\\"@timestamp\\",\\"splitAccessor\\":\\"jvm.thread.state\\",\\"accessors\\":[\\"Thread Count\\"],\\"layerType\\":\\"data\\",\\"colorMapping\\":{\\"assignments\\":[],\\"specialAssignments\\":[{\\"rule\\":{\\"type\\":\\"other\\"},\\"color\\":{\\"type\\":\\"loop\\"},\\"touched\\":false}],\\"paletteId\\":\\"eui_amsterdam_color_blind\\",\\"colorMode\\":{\\"type\\":\\"categorical\\"}}}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsXY\\"},\\"title\\":\\"Thread Count\\"},\\"panelIndex\\":\\"3950d3b8-c047-40f2-955e-988c5b33ba25\\",\\"gridData\\":{\\"i\\":\\"3950d3b8-c047-40f2-955e-988c5b33ba25\\",\\"y\\":28,\\"x\\":0,\\"w\\":24,\\"h\\":15}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"description\\":\\"Shows the memory usage per region relative to each region\'s limit\\",\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL),\\\\n         off_heap_limit = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          off_heap_limit = AVG(off_heap_limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used_rel = AVG(off_heap_used / off_heap_limit),\\\\n          heap_used_rel = AVG(heap_used / heap_limit)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used_rel AS `Non Heap`, heap_used_rel AS `Heap`\\"},\\"attributes\\":{\\"title\\":\\"Non Heap & Heap over @timestamp\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"345897d1-5b0d-4f3b-965c-455e61337195\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL),\\\\n         off_heap_limit = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          off_heap_limit = AVG(off_heap_limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used_rel = AVG(off_heap_used / off_heap_limit),\\\\n          heap_used_rel = AVG(heap_used / heap_limit)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used_rel AS `Non Heap`, heap_used_rel AS `Heap`\\"},\\"columns\\":[{\\"columnId\\":\\"Non Heap\\",\\"fieldName\\":\\"Non Heap\\",\\"label\\":\\"Non Heap\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"Heap\\",\\"fieldName\\":\\"Heap\\",\\"label\\":\\"Heap\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"jvm.memory.pool.name\\",\\"fieldName\\":\\"jvm.memory.pool.name\\",\\"label\\":\\"jvm.memory.pool.name\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\"}},{\\"columnId\\":\\"@timestamp\\",\\"fieldName\\":\\"@timestamp\\",\\"label\\":\\"@timestamp\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\"}}],\\"timeField\\":\\"@timestamp\\"}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.used::long IS NOT NULL OR jvm.memory.limit IS NOT NULL\\\\n  | EVAL heap_used = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         off_heap_used = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.used::long, NULL),\\\\n         heap_limit = CASE(jvm.memory.type == \\\\\\"heap\\\\\\", jvm.memory.limit, NULL),\\\\n         off_heap_limit = CASE(jvm.memory.type == \\\\\\"non_heap\\\\\\", jvm.memory.limit, NULL)\\\\n  | STATS heap_used = AVG(heap_used),\\\\n          off_heap_used = AVG(off_heap_used),\\\\n          heap_limit = AVG(heap_limit),\\\\n          off_heap_limit = AVG(off_heap_limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS off_heap_used_rel = AVG(off_heap_used / off_heap_limit),\\\\n          heap_used_rel = AVG(heap_used / heap_limit)\\\\n          BY jvm.memory.pool.name, @timestamp\\\\n  | RENAME off_heap_used_rel AS `Non Heap`, heap_used_rel AS `Heap`\\"},\\"visualization\\":{\\"legend\\":{\\"isVisible\\":false,\\"position\\":\\"right\\",\\"showSingleSeries\\":false},\\"valueLabels\\":\\"hide\\",\\"fittingFunction\\":\\"Linear\\",\\"yLeftExtent\\":{\\"mode\\":\\"custom\\",\\"lowerBound\\":0,\\"upperBound\\":1},\\"axisTitlesVisibilitySettings\\":{\\"x\\":false,\\"yLeft\\":false,\\"yRight\\":true},\\"tickLabelsVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"labelsOrientation\\":{\\"x\\":0,\\"yLeft\\":0,\\"yRight\\":0},\\"gridlinesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"preferredSeriesType\\":\\"line\\",\\"layers\\":[{\\"layerId\\":\\"345897d1-5b0d-4f3b-965c-455e61337195\\",\\"seriesType\\":\\"line\\",\\"xAccessor\\":\\"@timestamp\\",\\"splitAccessor\\":\\"jvm.memory.pool.name\\",\\"accessors\\":[\\"Non Heap\\",\\"Heap\\"],\\"layerType\\":\\"data\\",\\"colorMapping\\":{\\"assignments\\":[],\\"specialAssignments\\":[{\\"rule\\":{\\"type\\":\\"other\\"},\\"color\\":{\\"type\\":\\"loop\\"},\\"touched\\":false}],\\"paletteId\\":\\"eui_amsterdam_color_blind\\",\\"colorMode\\":{\\"type\\":\\"categorical\\"}}}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsXY\\"},\\"title\\":\\"Relative Memory Usage\\"},\\"panelIndex\\":\\"766fc18f-ad9c-428d-ab6b-741b2ebbc5c8\\",\\"gridData\\":{\\"i\\":\\"766fc18f-ad9c-428d-ab6b-741b2ebbc5c8\\",\\"y\\":28,\\"x\\":24,\\"w\\":24,\\"h\\":15}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.type == \\\\\\"heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit),\\\\n          mem_used_aftergc_max = MAX(jvm.memory.used_after_last_gc)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_aftergc_max = MAX(mem_used_aftergc_max),\\\\n          mem_used_aftergc_max_rel = MAX(mem_used_aftergc_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"attributes\\":{\\"title\\":\\"mem_limit_avg & mem_used_avg & mem_used_avg_rel & mem_used_aftergc_max & mem_used_aftergc_max_rel of (empty)\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"8eaca978-70ab-412e-85ea-ff3a0b47fc79\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.type == \\\\\\"heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit),\\\\n          mem_used_aftergc_max = MAX(jvm.memory.used_after_last_gc)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_aftergc_max = MAX(mem_used_aftergc_max),\\\\n          mem_used_aftergc_max_rel = MAX(mem_used_aftergc_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"columns\\":[{\\"columnId\\":\\"9ee85f9b-cf1a-43b2-a3e4-666950b79720\\",\\"fieldName\\":\\"jvm.memory.pool.name\\",\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\",\\"sourceParams\\":{}},\\"label\\":\\"Heap Region\\",\\"customLabel\\":true},{\\"columnId\\":\\"mem_limit_avg\\",\\"fieldName\\":\\"mem_limit_avg\\",\\"label\\":\\"Limit\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_avg\\",\\"fieldName\\":\\"mem_used_avg\\",\\"label\\":\\"Used avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_avg_rel\\",\\"fieldName\\":\\"mem_used_avg_rel\\",\\"label\\":\\"Used avg [%]\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_aftergc_max\\",\\"fieldName\\":\\"mem_used_aftergc_max\\",\\"label\\":\\"Max used after GC\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_aftergc_max_rel\\",\\"fieldName\\":\\"mem_used_aftergc_max_rel\\",\\"label\\":\\"Max used after GC [%]\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"332530a2-966e-4fcc-8872-67d09d8ffa11\\",\\"fieldName\\":\\"mem_comitted_avg\\",\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\",\\"sourceParams\\":{}},\\"label\\":\\"Committed avg\\",\\"customLabel\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"86051de0-aeed-4219-9807-40928d871d35\\",\\"fieldName\\":\\"mem_comitted_max\\",\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\",\\"sourceParams\\":{}},\\"label\\":\\"Committed max\\",\\"customLabel\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}}],\\"timeField\\":\\"@timestamp\\",\\"allColumns\\":[{\\"columnId\\":\\"mem_limit_avg\\",\\"fieldName\\":\\"mem_limit_avg\\",\\"label\\":\\"mem_limit_avg\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_avg\\",\\"fieldName\\":\\"mem_used_avg\\",\\"label\\":\\"mem_used_avg\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_avg_rel\\",\\"fieldName\\":\\"mem_used_avg_rel\\",\\"label\\":\\"mem_used_avg_rel\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_aftergc_max\\",\\"fieldName\\":\\"mem_used_aftergc_max\\",\\"label\\":\\"mem_used_aftergc_max\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_aftergc_max_rel\\",\\"fieldName\\":\\"mem_used_aftergc_max_rel\\",\\"label\\":\\"mem_used_aftergc_max_rel\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true}]}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.type == \\\\\\"heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit),\\\\n          mem_used_aftergc_max = MAX(jvm.memory.used_after_last_gc)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_aftergc_max = MAX(mem_used_aftergc_max),\\\\n          mem_used_aftergc_max_rel = MAX(mem_used_aftergc_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"visualization\\":{\\"layerId\\":\\"8eaca978-70ab-412e-85ea-ff3a0b47fc79\\",\\"layerType\\":\\"data\\",\\"columns\\":[{\\"columnId\\":\\"mem_limit_avg\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"mem_used_avg\\"},{\\"columnId\\":\\"mem_used_avg_rel\\"},{\\"columnId\\":\\"mem_used_aftergc_max\\"},{\\"columnId\\":\\"mem_used_aftergc_max_rel\\"},{\\"columnId\\":\\"9ee85f9b-cf1a-43b2-a3e4-666950b79720\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"332530a2-966e-4fcc-8872-67d09d8ffa11\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"86051de0-aeed-4219-9807-40928d871d35\\",\\"isTransposed\\":false,\\"isMetric\\":true}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsDatatable\\"},\\"title\\":\\"Heap Memory Region Statistics\\"},\\"panelIndex\\":\\"aad3ee85-0560-4aa1-a0a8-eca8bce3c310\\",\\"gridData\\":{\\"i\\":\\"aad3ee85-0560-4aa1-a0a8-eca8bce3c310\\",\\"y\\":43,\\"x\\":0,\\"w\\":24,\\"h\\":12}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.type == \\\\\\"non_heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_used_max = MAX(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_max = MAX(mem_used_max),\\\\n          mem_used_max_rel = MAX(mem_used_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"attributes\\":{\\"title\\":\\"mem_limit_avg & mem_used_avg & mem_used_avg_rel & mem_used_max & mem_used_max_rel of (empty)\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"5648ef32-9841-4178-a780-6236210c24ec\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"FROM *:metrics-*.otel-*,metrics-*.otel-*\\\\n  | WHERE jvm.memory.type == \\\\\\"non_heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_used_max = MAX(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_max = MAX(mem_used_max),\\\\n          mem_used_max_rel = MAX(mem_used_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"columns\\":[{\\"columnId\\":\\"ea434084-c4eb-4001-9015-68dee268164d\\",\\"fieldName\\":\\"jvm.memory.pool.name\\",\\"meta\\":{\\"type\\":\\"string\\",\\"esType\\":\\"keyword\\",\\"sourceParams\\":{}},\\"label\\":\\"Non-Heap Region\\",\\"customLabel\\":true},{\\"columnId\\":\\"mem_limit_avg\\",\\"fieldName\\":\\"mem_limit_avg\\",\\"label\\":\\"Limit\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_avg\\",\\"fieldName\\":\\"mem_used_avg\\",\\"label\\":\\"Used avg\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_avg_rel\\",\\"fieldName\\":\\"mem_used_avg_rel\\",\\"label\\":\\"Used avg [%]\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_max\\",\\"fieldName\\":\\"mem_used_max\\",\\"label\\":\\"Used max\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"mem_used_max_rel\\",\\"fieldName\\":\\"mem_used_max_rel\\",\\"label\\":\\"Used max [%]\\",\\"customLabel\\":true,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"percent\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"49731b15-ca79-49f4-918d-439fcbf5897c\\",\\"fieldName\\":\\"mem_comitted_avg\\",\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\",\\"sourceParams\\":{}},\\"label\\":\\"Committed avg\\",\\"customLabel\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}},{\\"columnId\\":\\"63bfaf80-517f-49f6-9980-c576dc013892\\",\\"fieldName\\":\\"mem_comitted_max\\",\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\",\\"sourceParams\\":{}},\\"label\\":\\"Committed max\\",\\"customLabel\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"bytes\\",\\"params\\":{\\"decimals\\":2}}}}],\\"timeField\\":\\"@timestamp\\",\\"allColumns\\":[{\\"columnId\\":\\"mem_limit_avg\\",\\"fieldName\\":\\"mem_limit_avg\\",\\"label\\":\\"mem_limit_avg\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_avg\\",\\"fieldName\\":\\"mem_used_avg\\",\\"label\\":\\"mem_used_avg\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_avg_rel\\",\\"fieldName\\":\\"mem_used_avg_rel\\",\\"label\\":\\"mem_used_avg_rel\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_max\\",\\"fieldName\\":\\"mem_used_max\\",\\"label\\":\\"mem_used_max\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"long\\"},\\"inMetricDimension\\":true},{\\"columnId\\":\\"mem_used_max_rel\\",\\"fieldName\\":\\"mem_used_max_rel\\",\\"label\\":\\"mem_used_max_rel\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true}]}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}]}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"FROM {{indexPattern}}\\\\n  | WHERE jvm.memory.type == \\\\\\"non_heap\\\\\\"\\\\n  | STATS cpu = AVG(jvm.cpu.recent_utilization),\\\\n          mem_used_avg = AVG(jvm.memory.used::long),\\\\n          mem_used_max = MAX(jvm.memory.used::long),\\\\n          mem_comitted_avg = AVG(jvm.memory.committed::long),\\\\n          mem_comitted_max = MAX(jvm.memory.committed::long),\\\\n          mem_limit_avg = AVG(jvm.memory.limit)\\\\n          BY service.instance.id, jvm.memory.pool.name, @timestamp = BUCKET(@timestamp, 1 minute)\\\\n  | STATS mem_limit_avg = AVG(mem_limit_avg),\\\\n          mem_used_avg = AVG(mem_used_avg),\\\\n          mem_used_avg_rel = MAX(mem_used_avg/mem_limit_avg),\\\\n          mem_used_max = MAX(mem_used_max),\\\\n          mem_used_max_rel = MAX(mem_used_max/mem_limit_avg),\\\\n          mem_comitted_avg = AVG(mem_comitted_avg),\\\\n          mem_comitted_max = MAX(mem_comitted_max)\\\\n          BY jvm.memory.pool.name\\"},\\"visualization\\":{\\"layerId\\":\\"5648ef32-9841-4178-a780-6236210c24ec\\",\\"layerType\\":\\"data\\",\\"columns\\":[{\\"isTransposed\\":false,\\"columnId\\":\\"mem_limit_avg\\",\\"isMetric\\":true,\\"width\\":85.27083333333333},{\\"columnId\\":\\"mem_used_avg\\"},{\\"columnId\\":\\"mem_used_avg_rel\\"},{\\"columnId\\":\\"mem_used_max\\",\\"width\\":94},{\\"columnId\\":\\"mem_used_max_rel\\",\\"width\\":73},{\\"columnId\\":\\"49731b15-ca79-49f4-918d-439fcbf5897c\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"63bfaf80-517f-49f6-9980-c576dc013892\\",\\"isTransposed\\":false,\\"isMetric\\":true},{\\"columnId\\":\\"ea434084-c4eb-4001-9015-68dee268164d\\",\\"isTransposed\\":false,\\"isMetric\\":true,\\"width\\":182.375}]},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsDatatable\\"},\\"title\\":\\"Non-Heap Memory Region Statistics\\"},\\"panelIndex\\":\\"d69d5206-25a3-4cd2-b617-538e45eaa71b\\",\\"gridData\\":{\\"i\\":\\"d69d5206-25a3-4cd2-b617-538e45eaa71b\\",\\"y\\":43,\\"x\\":24,\\"w\\":24,\\"h\\":12}},{\\"type\\":\\"lens\\",\\"embeddableConfig\\":{\\"enhancements\\":{\\"dynamicActions\\":{\\"events\\":[]}},\\"description\\":\\"The number of classes the JVM currently has loaded at a given point in time.\\",\\"syncColors\\":false,\\"syncCursor\\":true,\\"syncTooltips\\":false,\\"filters\\":[],\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS classes = AVG(jvm.class.count) BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS classes = AVG(classes) BY @timestamp\\\\n  | RENAME classes AS `Loaded Classes`\\"},\\"attributes\\":{\\"title\\":\\"Bar vertical stacked\\",\\"references\\":[],\\"state\\":{\\"datasourceStates\\":{\\"textBased\\":{\\"layers\\":{\\"84f364b6-3652-4e8a-b6f7-e08a4a50cabd\\":{\\"index\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS classes = AVG(jvm.class.count) BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS classes = AVG(classes) BY @timestamp\\\\n  | RENAME classes AS `Loaded Classes`\\"},\\"columns\\":[{\\"columnId\\":\\"Loaded Classes\\",\\"fieldName\\":\\"Loaded Classes\\",\\"variable\\":null,\\"label\\":\\"Loaded Classes\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"number\\",\\"esType\\":\\"double\\"},\\"inMetricDimension\\":true,\\"params\\":{\\"format\\":{\\"id\\":\\"number\\",\\"params\\":{\\"decimals\\":0}}}},{\\"columnId\\":\\"@timestamp\\",\\"fieldName\\":\\"@timestamp\\",\\"variable\\":null,\\"label\\":\\"@timestamp\\",\\"customLabel\\":false,\\"meta\\":{\\"type\\":\\"date\\",\\"esType\\":\\"date\\"}}],\\"timeField\\":\\"@timestamp\\"}},\\"indexPatternRefs\\":[{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeField\\":\\"@timestamp\\"}],\\"initialContext\\":null}},\\"filters\\":[],\\"query\\":{\\"esql\\":\\"  FROM {{indexPattern}}\\\\n  | STATS classes = AVG(jvm.class.count) BY service.instance.id, @timestamp = BUCKET(@timestamp, 100, ?_tstart, ?_tend)\\\\n  | STATS classes = AVG(classes) BY @timestamp\\\\n  | RENAME classes AS `Loaded Classes`\\"},\\"visualization\\":{\\"legend\\":{\\"isVisible\\":true,\\"position\\":\\"right\\"},\\"valueLabels\\":\\"hide\\",\\"fittingFunction\\":\\"None\\",\\"curveType\\":\\"LINEAR\\",\\"fillOpacity\\":null,\\"yRightTitle\\":null,\\"hideEndzones\\":null,\\"showCurrentTimeMarker\\":null,\\"yLeftExtent\\":null,\\"yRightExtent\\":null,\\"yLeftScale\\":null,\\"yRightScale\\":null,\\"axisTitlesVisibilitySettings\\":{\\"x\\":false,\\"yLeft\\":false,\\"yRight\\":true},\\"tickLabelsVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"labelsOrientation\\":{\\"x\\":0,\\"yLeft\\":0,\\"yRight\\":0},\\"gridlinesVisibilitySettings\\":{\\"x\\":true,\\"yLeft\\":true,\\"yRight\\":true},\\"preferredSeriesType\\":\\"line\\",\\"layers\\":[{\\"palette\\":null,\\"layerId\\":\\"84f364b6-3652-4e8a-b6f7-e08a4a50cabd\\",\\"seriesType\\":\\"line\\",\\"xAccessor\\":\\"@timestamp\\",\\"splitAccessor\\":null,\\"accessors\\":[\\"Loaded Classes\\"],\\"yConfig\\":null,\\"layerType\\":\\"data\\",\\"colorMapping\\":{\\"assignments\\":[],\\"specialAssignments\\":[{\\"rule\\":{\\"type\\":\\"other\\"},\\"color\\":{\\"type\\":\\"loop\\"},\\"touched\\":false}],\\"paletteId\\":\\"eui_amsterdam_color_blind\\",\\"colorMode\\":{\\"type\\":\\"categorical\\"}}}],\\"endValue\\":\\"None\\"},\\"adHocDataViews\\":{\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\":{\\"id\\":\\"d3b7e528216ce7ef65e68e07a803b7ab53e440cafdb52d9d7ee1ef4bbf5d8afa\\",\\"title\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"timeFieldName\\":\\"@timestamp\\",\\"sourceFilters\\":[],\\"type\\":\\"esql\\",\\"fieldFormats\\":{},\\"runtimeFieldMap\\":{},\\"fieldAttrs\\":null,\\"allowNoIndex\\":false,\\"name\\":\\"*:metrics-*.otel-*,metrics-*.otel-*\\",\\"allowHidden\\":false}},\\"needsRefresh\\":false},\\"visualizationType\\":\\"lnsXY\\"},\\"title\\":\\"Loaded Classes\\"},\\"panelIndex\\":\\"c60793aa-d9c6-40cc-9b28-0f77357e9c8c\\",\\"gridData\\":{\\"i\\":\\"c60793aa-d9c6-40cc-9b28-0f77357e9c8c\\",\\"y\\":55,\\"x\\":0,\\"w\\":48,\\"h\\":12}}]","timeRestore":false,"title":"JVM-Dashboard - otel-native","version":1},"coreMigrationVersion":"8.8.0","created_at":"2025-08-18T09:36:23.950Z","created_by":"u_gFwCjbbPdWG_Wgca78NWDZgy5m0yqpqwS2cqmwMPsEQ_0","id":"f29edbb0-2a0e-11ee-ba40-b1a1a11f1941","managed":false,"references":[{"id":"apm_static_data_view_id_default","name":"controlGroup_46ebbfe2-a47c-420c-8e27-c0d3cfb89446:optionsListDataView","type":"index-pattern"}],"type":"dashboard","typeMigrationVersion":"10.2.0","updated_at":"2025-08-18T09:42:07.061Z","updated_by":"u_gFwCjbbPdWG_Wgca78NWDZgy5m0yqpqwS2cqmwMPsEQ_0","version":"WzUxMSwxXQ=="}')}}]);