"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _server = require("@kbn/observability-plugin/server");
var _get_offset_in_ms = require("../../../../common/utils/get_offset_in_ms");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _apm = require("../../../../common/es_fields/apm");
var _get_bucket_size = require("../../../../common/utils/get_bucket_size");
var _event_outcome = require("../../../../common/event_outcome");
var _connections = require("../../../../common/connections");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
var _exclude_rum_exit_spans_query = require("../exclude_rum_exit_spans_query");
var _get_is_using_service_destination_metrics = require("../../helpers/spans/get_is_using_service_destination_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ITEMS = 1500;
const getStats = async ({
  apmEventClient,
  start,
  end,
  filter,
  numBuckets,
  offset,
  withTimeseries
}) => {
  var _response$aggregation, _response$aggregation2;
  const {
    offsetInMs,
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const response = await getConnectionStats({
    apmEventClient,
    startWithOffset,
    endWithOffset,
    filter,
    numBuckets,
    withTimeseries
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.connections.buckets.map(bucket => {
    var _bucket$total_latency, _bucket$total_latency2, _bucket$error_count$d, _bucket$success_count, _bucket$timeseries;
    const sample = bucket.sample.top[0].metrics;
    const serviceName = bucket.key.serviceName;
    const dependencyName = bucket.key.dependencyName;
    return {
      from: {
        id: (0, _objectHash.default)({
          serviceName
        }),
        serviceName,
        environment: sample[_apm.SERVICE_ENVIRONMENT] || _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value,
        agentName: sample[_apm.AGENT_NAME],
        type: _connections.NodeType.service
      },
      to: {
        id: (0, _objectHash.default)({
          dependencyName
        }),
        dependencyName,
        spanType: sample[_apm.SPAN_TYPE],
        spanSubtype: sample[_apm.SPAN_SUBTYPE] || '',
        type: _connections.NodeType.dependency
      },
      value: {
        latency_count: (_bucket$total_latency = bucket.total_latency_count.value) !== null && _bucket$total_latency !== void 0 ? _bucket$total_latency : 0,
        latency_sum: (_bucket$total_latency2 = bucket.total_latency_sum.value) !== null && _bucket$total_latency2 !== void 0 ? _bucket$total_latency2 : 0,
        error_count: (_bucket$error_count$d = bucket.error_count.doc_count) !== null && _bucket$error_count$d !== void 0 ? _bucket$error_count$d : 0,
        success_count: (_bucket$success_count = bucket.success_count.doc_count) !== null && _bucket$success_count !== void 0 ? _bucket$success_count : 0
      },
      timeseries: (_bucket$timeseries = bucket.timeseries) === null || _bucket$timeseries === void 0 ? void 0 : _bucket$timeseries.buckets.map(dateBucket => {
        var _dateBucket$total_lat, _dateBucket$total_lat2, _dateBucket$error_cou, _dateBucket$success_c;
        return {
          x: dateBucket.key + offsetInMs,
          latency_count: (_dateBucket$total_lat = dateBucket.total_latency_count.value) !== null && _dateBucket$total_lat !== void 0 ? _dateBucket$total_lat : 0,
          latency_sum: (_dateBucket$total_lat2 = dateBucket.total_latency_sum.value) !== null && _dateBucket$total_lat2 !== void 0 ? _dateBucket$total_lat2 : 0,
          error_count: (_dateBucket$error_cou = dateBucket.error_count.doc_count) !== null && _dateBucket$error_cou !== void 0 ? _dateBucket$error_cou : 0,
          success_count: (_dateBucket$success_c = dateBucket.success_count.doc_count) !== null && _dateBucket$success_c !== void 0 ? _dateBucket$success_c : 0
        };
      })
    };
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
};
exports.getStats = getStats;
async function getConnectionStats({
  apmEventClient,
  startWithOffset,
  endWithOffset,
  filter,
  numBuckets,
  withTimeseries
}) {
  const statsAggs = {
    total_latency_sum: {
      sum: {
        field: _apm.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM
      }
    },
    total_latency_count: {
      sum: {
        field: _apm.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT
      }
    },
    error_count: {
      filter: {
        bool: {
          filter: [{
            terms: {
              [_apm.EVENT_OUTCOME]: [_event_outcome.EventOutcome.failure]
            }
          }]
        }
      }
    },
    success_count: {
      filter: {
        bool: {
          filter: [{
            terms: {
              [_apm.EVENT_OUTCOME]: [_event_outcome.EventOutcome.success]
            }
          }]
        }
      }
    }
  };
  return apmEventClient.search('get_connection_stats', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ServiceDestinationMetric,
        rollupInterval: _rollup.RollupInterval.OneMinute
      }]
    },
    track_total_hits: true,
    size: 0,
    query: {
      bool: {
        filter: [...filter, ...(0, _get_is_using_service_destination_metrics.getDocumentTypeFilterForServiceDestinationStatistics)(true), ...(0, _server.rangeQuery)(startWithOffset, endWithOffset), ...(0, _exclude_rum_exit_spans_query.excludeRumExitSpansQuery)()]
      }
    },
    aggs: {
      connections: {
        composite: {
          size: MAX_ITEMS,
          sources: (0, _as_mutable_array.asMutableArray)([{
            serviceName: {
              terms: {
                field: _apm.SERVICE_NAME
              }
            }
          }, {
            dependencyName: {
              terms: {
                field: _apm.SPAN_DESTINATION_SERVICE_RESOURCE
              }
            }
          }])
        },
        aggs: {
          sample: {
            top_metrics: {
              size: 1,
              metrics: (0, _as_mutable_array.asMutableArray)([{
                field: _apm.SERVICE_ENVIRONMENT
              }, {
                field: _apm.AGENT_NAME
              }, {
                field: _apm.SPAN_TYPE
              }, {
                field: _apm.SPAN_SUBTYPE
              }]),
              sort: {
                '@timestamp': 'desc'
              }
            }
          },
          ...statsAggs,
          ...(withTimeseries ? {
            timeseries: {
              date_histogram: {
                field: '@timestamp',
                fixed_interval: (0, _get_bucket_size.getBucketSize)({
                  start: startWithOffset,
                  end: endWithOffset,
                  numBuckets,
                  minBucketSize: 60
                }).intervalString,
                extended_bounds: {
                  min: startWithOffset,
                  max: endWithOffset
                }
              },
              aggs: statsAggs
            }
          } : undefined)
        }
      }
    }
  });
}